<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta name="description" content="DayCare || Kids HTML Template">

  <title>DayCare Kids Template</title>

  <!-- Favicon -->
  <link rel="shortcut icon" type="image/x-icon" href="assets/media/favicon.webp">

  <!-- All CSS files -->

  <link rel="stylesheet" href="assets/css/vendor/font-awesome.css">
  <link rel="stylesheet" href="assets/css/vendor/bootstrap.min.css">
  <link rel="stylesheet" href="assets/css/vendor/slick.css">
  <link rel="stylesheet" href="assets/css/vendor/slick-theme.css">
  <link rel="stylesheet" href="assets/css/vendor/wow.min.css">
  <link rel="stylesheet" href="assets/js/vendor/jquery.magnific-popup.min.js">
  <link rel="stylesheet" href="assets/css/app.css">

   <!-- Google Analytics Code Start -->
   <script async src="https://www.googletagmanager.com/gtag/js?id=G-7MBQVLVJ5H"></script>
   <script>
     window.dataLayer = window.dataLayer || [];
 
     function gtag() {
       dataLayer.push(arguments);
     }
     gtag('js', new Date());
     gtag('config', 'G-7MBQVLVJ5H');
   </script>
   <!-- Google Analytics Code End -->
</head>

<body class="tt-smooth-scroll">

  <!-- Preloader Start -->
  <div id="preloader">
    <div class='baby'>
      <div class='head'>
          <div class='eye'></div>
          <div class='cheek'></div>
          <div class='horn'></div>
      </div>
      <div class='back'>
          <div class='tail'></div>
          <div class='hand'></div>
          <div class='feet'></div>
          <div class='ass'></div>
      </div>
  </div>
  </div>
  <!-- Preloader End -->

  <!-- Main Wrapper Start -->
  <div class="scroll-container" id="scroll-container">

    <!-- HEADER MENU START -->
    <header class="header">
      <div class="main-menu">
        <div class="container-fluid">
          <nav class="navigation">
            <div class="left-side">
              <a href="index.php" class="d-flex align-items-center">
                <img src="assets/media/logo.webp" alt="/logo" class="header-logo">
              </a>
              <div class="menu-button-right">
                <div class="main-menu__nav">
                  <ul class="main-menu__list">
                    <li><a href="index.php" class="active">Home</a></li>
                    <li><a href="about.php">About Us</a></li>
                    <li class="dropdown">
                      <a href="javascript:void(0); ">Services
                      </a>
                      <ul>
                        <li><a href="services.php">Services</a></li>
                        <li><a href="service-detail.php">Services detail</a></li>
                      </ul>
                    </li>
                    <li class="dropdown">
                      <a href="javascript:void(0); ">Blogs
                      </a>
                      <ul>
                        <li><a href="blogs.php">Blogs</a></li>
                        <li><a href="blog-with-sidbar.php">Blog With Sidebar</a></li>
                        <li><a href="blog-detail.php">Blog Detail</a></li>
                      </ul>
                    </li>
                    <li><a href="contact.php">Contact Us</a></li>
                  </ul>
                </div>
              </div>
            </div>
            <div class="main-menu__right">
              <div class="right-side">
                <div class="socialicons">
                  <a href="" class="icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="23" height="24" viewBox="0 0 23 24" fill="none">
                      <g clip-path="url(#clip0_13590_1771)">
                        <path
                          d="M17.0459 6.05531C17.4079 6.05531 17.7016 5.76158 17.7016 5.39965V1.46567C17.7016 1.10374 17.4079 0.810001 17.0459 0.810001H13.112C10.5811 0.810001 8.52231 2.86879 8.52231 5.39965V8.67797H6.55532C6.1934 8.67797 5.89966 8.97171 5.89966 9.33363V13.2676C5.89966 13.6295 6.1934 13.9233 6.55532 13.9233H8.52231V22.5343C8.52231 22.8963 8.81605 23.19 9.17798 23.19H13.112C13.4739 23.19 13.7676 22.8963 13.7676 22.5343V13.9233H16.3903C16.7107 13.9233 16.9843 13.6916 17.0372 13.3756L17.6929 9.4416C17.7243 9.25146 17.671 9.05694 17.5464 8.90964C17.4219 8.76277 17.2387 8.67797 17.0459 8.67797H13.7676V6.05531H17.0459ZM13.112 9.9893H16.2718L15.8347 12.612H13.112C12.75 12.612 12.4563 12.9057 12.4563 13.2676V21.8787H9.83364V13.2676C9.83364 12.9057 9.5399 12.612 9.17798 12.612H7.21099V9.9893H9.17798C9.5399 9.9893 9.83364 9.69556 9.83364 9.33363V5.39965C9.83364 3.5922 11.3045 2.12133 13.112 2.12133H16.3903V4.74399H13.112C12.75 4.74399 12.4563 5.03772 12.4563 5.39965V9.33363C12.4563 9.69556 12.75 9.9893 13.112 9.9893Z"
                          fill="#21AC94" />
                      </g>
                      <defs>
                        <clipPath>
                          <rect width="22.38" height="22.38" fill="white" transform="translate(0.610718 0.810001)" />
                        </clipPath>
                      </defs>
                    </svg>
                  </a>
                  <a href="" class="icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="23" height="24" viewBox="0 0 23 24" fill="none">
                      <g clip-path="url(#clip0_13590_1773)">
                        <path
                          d="M11.401 23.19C11.3269 23.19 11.2528 23.19 11.1782 23.1897C9.42392 23.194 7.80303 23.1494 6.2267 23.0534C4.78151 22.9655 3.46233 22.4661 2.41156 21.6093C1.39767 20.7825 0.705294 19.6646 0.353728 18.2871C0.0477518 17.0877 0.0315309 15.9104 0.015993 14.7717C0.00472379 13.9547 -0.0068869 12.9866 -0.00927734 12.0021C-0.0068869 11.0135 0.00472379 10.0453 0.015993 9.22831C0.0315309 8.08978 0.0477518 6.91249 0.353728 5.713C0.705294 4.33542 1.39767 3.21755 2.41156 2.39079C3.46233 1.53399 4.78151 1.03456 6.22687 0.946627C7.8032 0.850838 9.42443 0.806103 11.1824 0.810372C12.9372 0.806615 14.5576 0.850838 16.1339 0.946627C17.5791 1.03456 18.8983 1.53399 19.949 2.39079C20.9631 3.21755 21.6553 4.33542 22.0069 5.713C22.3128 6.91231 22.3291 8.08978 22.3446 9.22831C22.3559 10.0453 22.3676 11.0135 22.3699 11.998V12.0021C22.3676 12.9866 22.3559 13.9547 22.3446 14.7717C22.3291 15.9103 22.313 17.0876 22.0069 18.2871C21.6553 19.6646 20.9631 20.7825 19.949 21.6093C18.8983 22.4661 17.5791 22.9655 16.1339 23.0534C14.6243 23.1453 13.0736 23.19 11.401 23.19ZM11.1782 21.8036C12.9039 21.8077 14.4884 21.7639 16.0277 21.6704C17.1205 21.604 18.4095 20.8872 19.1857 20.2542C19.9031 19.6691 20.3973 18.8618 20.6543 17.8547C20.909 16.8564 20.9237 15.7844 20.9379 14.7478C20.949 13.9363 20.9606 12.975 20.963 12C20.9606 11.0249 20.949 10.0638 20.9379 9.25222C20.9237 8.21562 20.909 7.14368 20.6543 6.14515C20.3973 5.1381 19.9031 4.33081 19.1857 3.74566C18.4095 3.11288 17.1205 2.41708 16.0277 2.35066C14.4884 2.25692 12.9039 2.21373 11.1823 2.21748C9.45687 2.21338 7.87218 2.26205 6.3329 2.35579C5.24013 2.42221 4.07065 2.89087 3.29444 3.52365C2.57697 4.1088 1.94996 5.1381 1.69298 6.14515C1.43823 7.14368 1.42355 8.21545 1.40937 9.25222C1.39828 10.0645 1.38667 11.0263 1.38427 12.0021C1.38667 12.9736 1.39828 13.9356 1.40937 14.7478C1.42355 15.7844 1.43823 16.8564 1.69298 17.8547C1.94996 18.8618 2.44409 19.6691 3.16157 20.2542C3.93778 20.887 5.24013 21.604 6.3329 21.6704C7.87218 21.7641 9.45721 21.8078 11.1782 21.8036ZM11.1365 17.4639C8.12386 17.4639 5.67263 15.0128 5.67263 12C5.67263 8.98722 8.12386 6.53616 11.1365 6.53616C14.1493 6.53616 16.6004 8.98722 16.6004 12C16.6004 15.0128 14.1493 17.4639 11.1365 17.4639ZM11.1823 7.8084C8.72561 7.8084 6.99672 9.53729 6.99672 11.998C6.99672 14.0466 8.54581 16.2085 11.1581 16.2085C13.2069 16.2085 15.3369 14.2675 15.3369 11.998C15.3369 9.94937 13.774 7.8084 11.1823 7.8084ZM17.2123 4.78772C16.4882 4.78772 15.901 5.37475 15.901 6.09905C15.901 6.82336 16.4882 7.41038 17.2123 7.41038C17.9366 7.41038 18.5236 6.82336 18.5236 6.09905C18.5236 5.37475 17.9366 4.78772 17.2123 4.78772Z"
                          fill="#21AC94" />
                      </g>
                      <defs>
                        <clipPath>
                          <rect width="22.38" height="22.38" fill="white" transform="translate(-0.00927734 0.810001)" />
                        </clipPath>
                      </defs>
                    </svg>
                  </a>
                  <a href="" class="icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="23" height="24" viewBox="0 0 23 24" fill="none">
                      <g clip-path="url(#clip0_13590_1775)">
                        <path
                          d="M19.4253 4.05998C17.3229 1.96544 14.5261 0.811197 11.5495 0.810001C8.5795 0.810001 5.77825 1.96322 3.66202 4.05725C1.54204 6.15486 0.373459 8.94246 0.370728 11.8964V11.9018C0.371069 13.6897 0.840791 15.4933 1.73243 17.1396L0.401291 23.19L6.52133 21.7979C8.07136 22.5791 9.80085 22.9909 11.5452 22.9916H11.5496C14.5191 22.9916 17.3203 21.8382 19.4369 19.744C21.5588 17.6447 22.7278 14.8607 22.7292 11.9049C22.7301 8.96994 21.5569 6.18389 19.4253 4.05998ZM11.5496 21.6027C9.98338 21.602 8.42737 21.2654 7.05782 20.5218L6.7684 20.3647L2.14175 21.4437L3.17908 16.8586L3.00867 16.5647C2.16143 15.1036 1.83131 13.4908 1.83131 11.8999C1.83455 6.75076 6.35144 2.32497 11.5491 2.32497C14.0601 2.326 16.5016 3.29942 18.2746 5.06561C20.0744 6.85913 21.2664 9.43728 21.2656 11.9044C21.2635 17.0905 16.6244 21.6027 11.5496 21.6027Z"
                          fill="#21AC94" />
                        <path
                          d="M8.50762 7.01098H8.01758C7.847 7.01098 7.57006 7.07484 7.33579 7.32976C7.10136 7.58485 6.44074 8.20142 6.44074 9.45537C6.44074 10.7093 7.35714 11.9209 7.48485 12.0912C7.61274 12.2612 9.25378 14.9167 11.8529 15.9383C14.013 16.7872 14.4527 16.6183 14.9213 16.5758C15.3902 16.5335 16.4343 15.9594 16.6474 15.3644C16.8605 14.7693 16.8605 14.2591 16.7966 14.1526C16.7326 14.0464 16.562 13.9827 16.3064 13.8553C16.0507 13.7278 14.7974 13.1008 14.563 13.0156C14.3285 12.9307 14.1581 12.8882 13.9875 13.1435C13.817 13.3982 13.3148 13.9877 13.1656 14.1577C13.0165 14.3279 12.8673 14.3493 12.6115 14.2217C12.3557 14.0939 11.5406 13.82 10.5637 12.9519C9.80341 12.2763 9.27581 11.4147 9.12657 11.1596C8.97751 10.9047 9.11069 10.7667 9.23892 10.6395C9.35384 10.5254 9.50904 10.3694 9.63693 10.2207C9.76465 10.0718 9.80102 9.96556 9.88639 9.7955C9.9716 9.62544 9.92891 9.47655 9.86505 9.34917C9.80102 9.22162 9.3103 7.96135 9.08286 7.45731C8.89129 7.03283 8.68981 7.01849 8.50762 7.01098Z"
                          fill="#21AC94" />
                      </g>
                      <defs>
                        <clipPath>
                          <rect width="22.38" height="22.38" fill="white" transform="translate(0.370728 0.810001)" />
                        </clipPath>
                      </defs>
                    </svg>
                  </a>
                </div>
                <div class="align-items-center gap-16 d-sm-flex d-none">
                  <a href="tel:+16413456413" class="cus-btn-2">
                    <span class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                        <g clip-path="url(#clip0_13590_1780)">
                          <path
                            d="M12.8699 12.2541L12.549 11.7184C11.972 10.767 11.1757 9.67506 10.1311 9.67506C9.93756 9.67506 9.74591 9.71399 9.55621 9.79281L8.99555 10.0332C8.94435 10.0545 8.89459 10.0786 8.84193 10.1042C8.69843 10.174 8.53572 10.2531 8.36836 10.2531C7.9555 10.2531 7.47714 9.71579 7.02161 8.74027C6.57454 7.78278 6.60306 7.28083 6.70568 7.02826C6.81892 6.7496 7.08225 6.63046 7.36515 6.52339C7.40449 6.50847 7.44002 6.49494 7.47457 6.48072L8.0423 6.24168C9.52137 5.62315 8.97113 3.46165 8.79072 2.75299L8.63772 2.1437C8.50692 1.64154 8.16012 0.307693 7.00981 0.307693C6.79686 0.307693 6.56968 0.357306 6.3348 0.455212C6.18069 0.516412 4.05992 1.3821 3.29159 2.90294C2.37331 4.7132 2.5431 7.14074 3.79576 10.1166C5.03905 13.0962 6.65128 14.9186 8.58769 15.5333C8.91985 15.6388 9.29524 15.6922 9.70352 15.6922H9.70373C11.0401 15.6922 12.3592 15.1237 12.4663 15.0765C12.927 14.8813 13.2248 14.5847 13.3514 14.1948C13.5659 13.5336 13.206 12.8092 12.8699 12.2541ZM12.3613 13.8735C12.3319 13.9641 12.2296 14.0468 12.0575 14.1193C12.0547 14.1205 12.0512 14.122 12.0483 14.1233C12.0363 14.1286 10.8423 14.6516 9.70345 14.6515C9.40217 14.6515 9.13273 14.6144 8.90264 14.5413C7.27126 14.0235 5.87629 12.4 4.75561 9.71433C3.62659 7.03201 3.44619 4.89874 4.22014 3.37304C4.82111 2.18353 6.70256 1.42893 6.72102 1.42172C6.72476 1.42019 6.72844 1.41873 6.73212 1.41721C6.83925 1.37224 6.93529 1.34851 7.00981 1.34851C7.23914 1.34851 7.44786 1.70419 7.62924 2.40133L7.78154 3.00806C8.11016 4.29868 8.06013 5.10594 7.63944 5.2819L7.07441 5.5199C7.05193 5.5292 7.02563 5.53899 6.99663 5.55002C6.68452 5.66819 6.03505 5.91396 5.74133 6.63643C5.47481 7.292 5.58514 8.12424 6.07828 9.18074C6.74246 10.6027 7.4915 11.2939 8.36822 11.2939C8.77511 11.2939 9.10172 11.1352 9.29684 11.0404C9.33278 11.0229 9.3649 11.0069 9.39946 10.9926L9.96095 10.7518C10.0189 10.7277 10.0745 10.7159 10.131 10.7159C10.4013 10.7159 10.8859 10.9836 11.6576 12.2557L11.9783 12.7911C12.3734 13.4436 12.4046 13.7399 12.3613 13.8735Z"
                            fill="#21AC94" />
                        </g>
                        <defs>
                          <clipPath>
                            <rect width="15.3846" height="15.3846" fill="white"
                              transform="translate(0.370728 0.307693)" />
                          </clipPath>
                        </defs>
                      </svg>
                    </span>
                    <span class="text">+16413456413</span>
                  </a>
                  <a href="services.php" class="cus-btn">
                    <span class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                        <g clip-path="url(#clip0_13590_1786)">
                          <path
                            d="M15.2478 0.439753C15.1203 0.312229 14.9291 0.273016 14.7618 0.339963L0.278578 6.13316C0.112863 6.19945 0.00189545 6.35726 -0.00447473 6.53565C-0.0108149 6.71402 0.0887042 6.87931 0.249281 6.9572L5.96045 9.72705L8.73033 15.4382C8.80587 15.594 8.96363 15.6923 9.13577 15.6923C9.14112 15.6923 9.1465 15.6922 9.15188 15.692C9.33021 15.6856 9.48809 15.5747 9.55434 15.409L15.3476 0.92587C15.4145 0.758442 15.3753 0.567246 15.2478 0.439753ZM1.56055 6.59127L13.0577 1.99245L6.20588 8.84421L1.56055 6.59127ZM9.09626 14.127L6.84329 9.48159L13.6951 2.62983L9.09626 14.127Z"
                            fill="#F7B631" />
                        </g>
                        <defs>
                          <clipPath>
                            <rect width="15.3846" height="15.3846" fill="white"
                              transform="translate(-0.00463867 0.307693)" />
                          </clipPath>
                        </defs>
                      </svg>
                    </span>
                    <span class="text">Get Started</span>
                  </a>
                </div>
              </div>
              <a href="" class="d-xl-none d-flex main-menu__toggler mobile-nav__toggler">
                <img src="assets/media/vector/menu-2.webp" alt="">
              </a>
            </div>
          </nav>
        </div>
      </div>
    </header>
    <div class="stricky-header stricked-menu">
      <div class="sticky-header__content"></div>
    </div>
    <!-- HEADER MENU END -->

    <!-- Hero Section Start -->
    <section class="hero-banner mb-100">
      <div class="row row-gap-4">
        <div class="col-lg-6 wow fadeInUp animated" data-wow-delay="2.6s">
          <div class="hero-content">
            <img src="assets/media/hero/vec-1.webp" class="vec-1" alt="vec1">
            <img src="assets/media/hero/vec-2.webp" class="vec-2" alt="vec1">
            <div class="d-flex align-items-center gap-8 mb-8">
              <svg class="startsvg" xmlns="http://www.w3.org/2000/svg" width="33" height="35" viewBox="0 0 33 35"
                fill="none">
                <path fill-rule="evenodd" clip-rule="evenodd"
                  d="M16 29.0053C12.6809 29.0053 10 26.3114 10 23C10 26.3114 7.30851 29.0053 4 29.0053C7.30851 29.0053 10 31.6886 10 35C10 31.6886 12.6809 29.0053 16 29.0053Z"
                  fill="#F3CE05" />
                <path fill-rule="evenodd" clip-rule="evenodd"
                  d="M33 24.1847C27.4681 24.1847 23 19.6949 23 14.1758C23 19.6949 18.5142 24.1847 13 24.1847C18.5142 24.1847 23 28.6567 23 34.1758C23 28.6567 27.4681 24.1847 33 24.1847Z"
                  fill="#F3CE05" />
                <path fill-rule="evenodd" clip-rule="evenodd"
                  d="M24 12.0106C17.3617 12.0106 12 6.62289 12 0C12 6.62289 6.61702 12.0106 0 12.0106C6.61702 12.0106 12 17.3771 12 24C12 17.3771 17.3617 12.0106 24 12.0106Z"
                  fill="#F3CE05" />
              </svg>
              <p>At Little Stars Day Care Center</p>
            </div>
            <h1 class="fw-500 mb-16">Here Little Minds <span class="color-primary"> Grow & Shine!</span></h1>
            <p class="mb-48">At we believe every child deserves a safe, nurturing, and fun environment to learn, play,
              and grow. Our experienced caregivers provide high-quality early childhood education while fostering
              creativity, curiosity, and confidence in every little one.</p>
            <div>
              <a href="about.php" class="cus-btn">
                <span class="icon">
                  <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                    <g clip-path="url(#clip0_13590_1786)">
                      <path
                        d="M15.2478 0.439753C15.1203 0.312229 14.9291 0.273016 14.7618 0.339963L0.278578 6.13316C0.112863 6.19945 0.00189545 6.35726 -0.00447473 6.53565C-0.0108149 6.71402 0.0887042 6.87931 0.249281 6.9572L5.96045 9.72705L8.73033 15.4382C8.80587 15.594 8.96363 15.6923 9.13577 15.6923C9.14112 15.6923 9.1465 15.6922 9.15188 15.692C9.33021 15.6856 9.48809 15.5747 9.55434 15.409L15.3476 0.92587C15.4145 0.758442 15.3753 0.567246 15.2478 0.439753ZM1.56055 6.59127L13.0577 1.99245L6.20588 8.84421L1.56055 6.59127ZM9.09626 14.127L6.84329 9.48159L13.6951 2.62983L9.09626 14.127Z"
                        fill="#F7B631" />
                    </g>
                    <defs>
                      <clipPath>
                        <rect width="15.3846" height="15.3846" fill="white"
                          transform="translate(-0.00463867 0.307693)" />
                      </clipPath>
                    </defs>
                  </svg>
                </span>
                <span class="text">Read More</span>
              </a>
            </div>
          </div>
        </div>
        <div class="col-lg-6">
          <img src="assets/media/hero/hero-img.webp" alt="hero-img">
        </div>
      </div>
      <div class="cloud-bg"></div>
      <div class="cloud cloud1"></div>
      <div class="cloud cloud2"></div>
      <div class="cloud cloud3"></div>
      <div class="cloud cloud4"></div>
    </section>
    <!-- Hero Section End -->

    <!-- About Section Start -->
    <section class="about-sec mb-120 wow fadeInUp animated" data-wow-delay="300ms">
      <div class="container-fluid">
        <div class="row row-gap-4">
          <div class="col-lg-5">
            <img src="assets/media/images/about-img.webp" class="w-100" alt="">
          </div>
          <div class="col-lg-7">
            <div class="pl-24">
              <h2 class="mb-16">Day care, where the little kids rise <span class="color-sec"> high and shine
                  more</span> </h2>
              <p class="mb-48">At our daycare, we firmly believe that every child deserves a safe, nurturing, and
                enjoyable environment where they can learn, play, and grow. Our dedicated caregivers are not only trained
                professionals but also passionate individuals who deliver top-notch early childhood education. We focus on
                fostering creativity, curiosity, and confidence in each child, ensuring that they feel valued and
                supported. Our curriculum is designed to engage children in a variety of activities that promote social,
                emotional, and cognitive development. From interactive storytelling sessions to hands-on art projects, we
                provide a rich array of experiences that stimulate young minds.</p>
              <a href="about.php" class="link-block mb-16">
                <h4 class="dark-gray">Playing Area with Creative Toys</h4>
                <div class="d-flex align-items-center gap-24">
                  <div class="image-effect">
                    <img src="assets/media/images/about-img-1.webp" class="link-img" alt="">
                  </div>
                  <svg xmlns="http://www.w3.org/2000/svg" width="64" height="65" viewBox="0 0 64 65" fill="none">
                    <path d="M16.9142 47.586L47.0841 17.4162M47.0841 17.4162H24.4566M47.0841 17.4162V40.0436"
                      stroke="#0C0C0D" stroke-width="5.33333" stroke-linecap="round" stroke-linejoin="round" />
                  </svg>
                </div>
              </a>
              <a href="about.php" class="link-block mb-48">
                <h4 class="dark-gray">Activity Room with Innovative Idea</h4>
                <div class="d-flex align-items-center gap-24">
                  <div class="image-effect">
                    <img src="assets/media/images/about-img-2.webp" class="link-img" alt="">
                  </div>
                  <svg xmlns="http://www.w3.org/2000/svg" width="64" height="65" viewBox="0 0 64 65" fill="none">
                    <path d="M16.9142 47.586L47.0841 17.4162M47.0841 17.4162H24.4566M47.0841 17.4162V40.0436"
                      stroke="#0C0C0D" stroke-width="5.33333" stroke-linecap="round" stroke-linejoin="round" />
                  </svg>
                </div>
              </a>
              <div>
                <a href="about.php" class="cus-btn">
                  <span class="icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                      <g clip-path="url(#clip0_13590_1786)">
                        <path
                          d="M15.2478 0.439753C15.1203 0.312229 14.9291 0.273016 14.7618 0.339963L0.278578 6.13316C0.112863 6.19945 0.00189545 6.35726 -0.00447473 6.53565C-0.0108149 6.71402 0.0887042 6.87931 0.249281 6.9572L5.96045 9.72705L8.73033 15.4382C8.80587 15.594 8.96363 15.6923 9.13577 15.6923C9.14112 15.6923 9.1465 15.6922 9.15188 15.692C9.33021 15.6856 9.48809 15.5747 9.55434 15.409L15.3476 0.92587C15.4145 0.758442 15.3753 0.567246 15.2478 0.439753ZM1.56055 6.59127L13.0577 1.99245L6.20588 8.84421L1.56055 6.59127ZM9.09626 14.127L6.84329 9.48159L13.6951 2.62983L9.09626 14.127Z"
                          fill="#F7B631" />
                      </g>
                      <defs>
                        <clipPath>
                          <rect width="15.3846" height="15.3846" fill="white"
                            transform="translate(-0.00463867 0.307693)" />
                        </clipPath>
                      </defs>
                    </svg>
                  </span>
                  <span class="text">Read More</span>
                </a>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- About Section End -->

    <!-- What They Learn Section Start -->
    <section class="learn-sec mb-120">
      <div class="container-fluid">
        <div class="text-center mb-48">
          <h2 class="mb-16">What they <span class="color-primary">Learn?</span></h2>
          <p>At our daycare, we firmly believe that every child deserves a safe, nurturing, and enjoyable environmen.
          </p>
        </div>
        <div class="row row-gap-4">
          <div class="col-lg-3 col-md-6 wow fadeInUp animated" data-wow-delay="400ms">
            <div class="learn-block">
              <div class="svg">
                <svg xmlns="http://www.w3.org/2000/svg" width="128" height="128" viewBox="0 0 128 128" fill="none">
                  <path
                    d="M56.791 117.785H15.6963C9.24706 117.785 4 112.537 4 106.088V64.9941C4 58.5449 9.24708 53.2969 15.6963 53.2969H56.791C63.2412 53.2969 68.4883 58.5449 68.4883 64.9941V106.088C68.4883 112.537 63.2412 117.785 56.791 117.785ZM15.6963 57.2969C11.4521 57.2969 8 60.75 8 64.9941V106.088C8 110.332 11.4521 113.785 15.6963 113.785H56.791C61.0351 113.785 64.4883 110.332 64.4883 106.088V64.9941C64.4883 60.75 61.0351 57.2969 56.791 57.2969H15.6963Z"
                    fill="#0C0C0D" />
                  <path
                    d="M25.8711 82.3906C21.6709 82.3906 18.2539 78.9727 18.2539 74.7734C18.2539 70.5742 21.6709 67.1562 25.8711 67.1562C30.0713 67.1562 33.4883 70.5742 33.4883 74.7734C33.4883 78.9727 30.0713 82.3906 25.8711 82.3906ZM25.8711 71.1562C23.8769 71.1562 22.2539 72.7793 22.2539 74.7734C22.2539 76.7676 23.8769 78.3906 25.8711 78.3906C27.8652 78.3906 29.4883 76.7676 29.4883 74.7734C29.4883 72.7793 27.8652 71.1562 25.8711 71.1562Z"
                    fill="#0C0C0D" />
                  <path
                    d="M25.8711 103.922C21.6709 103.922 18.2539 100.504 18.2539 96.3047C18.2539 92.1055 21.6709 88.6875 25.8711 88.6875C30.0713 88.6875 33.4883 92.1055 33.4883 96.3047C33.4883 100.504 30.0713 103.922 25.8711 103.922ZM25.8711 92.6875C23.8769 92.6875 22.2539 94.3105 22.2539 96.3047C22.2539 98.2988 23.8769 99.9218 25.8711 99.9218C27.8652 99.9218 29.4883 98.2988 29.4883 96.3047C29.4883 94.3105 27.8652 92.6875 25.8711 92.6875Z"
                    fill="#0C0C0D" />
                  <path
                    d="M48.3389 82.3906C44.1397 82.3906 40.7227 78.9727 40.7227 74.7734C40.7227 70.5742 44.1397 67.1562 48.3389 67.1562C52.5391 67.1562 55.9561 70.5742 55.9561 74.7734C55.9561 78.9727 52.5391 82.3906 48.3389 82.3906ZM48.3389 71.1562C46.3447 71.1562 44.7227 72.7793 44.7227 74.7734C44.7227 76.7676 46.3447 78.3906 48.3389 78.3906C50.333 78.3906 51.9561 76.7676 51.9561 74.7734C51.9561 72.7793 50.333 71.1562 48.3389 71.1562Z"
                    fill="#0C0C0D" />
                  <path
                    d="M48.3389 103.922C44.1397 103.922 40.7227 100.504 40.7227 96.3047C40.7227 92.1055 44.1397 88.6875 48.3389 88.6875C52.5391 88.6875 55.9561 92.1055 55.9561 96.3047C55.9561 100.504 52.5391 103.922 48.3389 103.922ZM48.3389 92.6875C46.3447 92.6875 44.7227 94.3105 44.7227 96.3047C44.7227 98.2988 46.3447 99.9218 48.3389 99.9218C50.333 99.9218 51.9561 98.2988 51.9561 96.3047C51.9561 94.3105 50.333 92.6875 48.3389 92.6875Z"
                    fill="#0C0C0D" />
                  <path
                    d="M76.8258 87.8761C72.0348 87.8761 67.4049 85.2511 65.0827 80.7042L64.7184 79.9972C64.2126 79.0148 64.5993 77.8097 65.5807 77.3038C66.5641 76.7902 67.7702 77.1827 68.2751 78.1652L68.6422 78.8781C70.9333 83.3663 76.4401 85.171 80.9235 82.8956L115.001 65.5714C117.177 64.4699 118.791 62.587 119.547 60.2687C120.304 57.9503 120.113 55.4738 119.01 53.296L101.685 19.2179C99.4127 14.7316 93.9098 12.9308 89.4088 15.2081L55.3317 32.5343C50.8424 34.8078 49.0446 40.3136 51.321 44.8117L56.2077 54.3976C56.7087 55.382 56.318 56.5871 55.3337 57.0871C54.3464 57.589 53.1432 57.1964 52.6432 56.214L47.7546 46.6222C44.4801 40.1535 47.068 32.2355 53.5221 28.966L87.5993 11.6398C94.0671 8.36832 101.986 10.9543 105.253 17.4074L122.578 51.4855C124.164 54.6183 124.437 58.1769 123.35 61.5089C122.261 64.8449 119.939 67.5539 116.81 69.1398L82.7331 86.464C80.8395 87.423 78.819 87.8761 76.8258 87.8761Z"
                    fill="#0C0C0D" />
                  <path
                    d="M71.0589 51.7687C68.2796 51.7687 65.5969 50.2452 64.2551 47.6046C62.3528 43.8605 63.8508 39.2667 67.595 37.3624C71.3401 35.464 75.9348 36.9601 77.8362 40.7023C79.7385 44.4464 78.2405 49.0402 74.4964 50.9445C73.3938 51.5031 72.218 51.7687 71.0589 51.7687ZM71.0393 40.5363C70.4885 40.5363 69.9299 40.6632 69.4065 40.9288C67.6292 41.8331 66.9182 44.0148 67.8215 45.7921C68.7239 47.5714 70.9094 48.2804 72.6848 47.3781C74.4622 46.4738 75.1731 44.2921 74.2698 42.5148C73.6331 41.2609 72.3586 40.5363 71.0393 40.5363Z"
                    fill="#21AC94" />
                  <path
                    d="M80.8108 70.964C78.0345 70.964 75.3528 69.4406 74.009 66.7999C72.1067 63.0558 73.6047 58.462 77.3489 56.5578C81.095 54.6593 85.6877 56.1554 87.5901 59.8976C88.512 61.7121 88.6721 63.7765 88.0413 65.7101C87.4104 67.6437 86.0637 69.216 84.2493 70.1378C83.1467 70.6984 81.971 70.964 80.8108 70.964ZM80.7932 59.7316C80.2424 59.7316 79.6838 59.8585 79.1604 60.1242C77.3831 61.0285 76.6721 63.2101 77.5754 64.9874C78.4778 66.7648 80.6604 67.4777 82.4377 66.5714C83.2991 66.1339 83.9387 65.3878 84.2385 64.4699C84.5373 63.5519 84.4612 62.5714 84.0237 61.7101C83.387 60.4562 82.1125 59.7316 80.7932 59.7316Z"
                    fill="#21AC94" />
                  <path
                    d="M91.0862 41.592C88.3069 41.592 85.6243 40.0686 84.2825 37.428C82.3801 33.6838 83.8782 29.0901 87.6223 27.1858C91.3684 25.2893 95.9631 26.7835 97.8635 30.5256C99.7659 34.2698 98.2678 38.8635 94.5237 40.7678C93.4212 41.3264 92.2454 41.592 91.0862 41.592ZM91.0667 30.3596C90.5159 30.3596 89.9573 30.4866 89.4338 30.7522C87.6565 31.6565 86.9456 33.8381 87.8489 35.6155C88.7522 37.3909 90.9348 38.1057 92.7122 37.2014C94.4895 36.2971 95.2004 34.1155 94.2971 32.3381C93.6604 31.0842 92.386 30.3596 91.0667 30.3596Z"
                    fill="#21AC94" />
                  <path
                    d="M100.836 60.7908C100.041 60.7908 99.2435 60.6658 98.4662 60.4119C96.5316 59.781 94.9593 58.4353 94.0374 56.6209C93.1156 54.8064 92.9554 52.742 93.5863 50.8084C94.2171 48.8748 95.5638 47.3025 97.3783 46.3806C99.1917 45.4607 101.258 45.2986 103.19 45.9294C105.124 46.5603 106.697 47.906 107.618 49.7205C108.54 51.5349 108.701 53.5994 108.07 55.533C107.439 57.4666 106.092 59.0388 104.278 59.9607C103.194 60.5115 102.019 60.7908 100.836 60.7908ZM100.825 49.5525C100.263 49.5525 99.7054 49.6853 99.1898 49.947C98.3285 50.3845 97.6888 51.1306 97.389 52.0486C97.0902 52.9666 97.1663 53.947 97.6038 54.8084C98.0413 55.6697 98.7884 56.3103 99.7064 56.6091C100.624 56.9099 101.603 56.8298 102.466 56.3943C103.327 55.9568 103.967 55.2107 104.267 54.2927C104.566 53.3748 104.49 52.3943 104.052 51.533C103.615 50.6717 102.868 50.031 101.95 49.7322C101.58 49.6111 101.202 49.5525 100.825 49.5525Z"
                    fill="#21AC94" />
                </svg>
              </div>
              <h5>Playing Fun Games</h5>
              <p>At our daycare, we firmly believe that every child deserves a safe, nurturing, and enjoyable
                environment where they can learnotch early childhood education.</p>
            </div>
          </div>
          <div class="col-lg-3 col-md-6 wow fadeInUp animated" data-wow-delay="550ms">
            <div class="learn-block">
              <div class="svg">
                <svg xmlns="http://www.w3.org/2000/svg" width="128" height="128" viewBox="0 0 128 128" fill="none">
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M38.325 52.1483C33.0692 52.1483 28.4715 48.698 27.0985 43.5728C26.8251 42.5519 27.4307 41.5028 28.4515 41.2291C29.4727 40.956 30.5215 41.5616 30.7952 42.5821C32.4476 48.7455 40.4355 50.376 44.3731 45.3866C45.0278 44.5568 46.2307 44.4152 47.0606 45.07C47.8901 45.7248 48.0316 46.928 47.3772 47.7575C45.1554 50.5723 41.828 52.1483 38.325 52.1483Z"
                    fill="#21AC94" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M23.8277 66.1001C22.0248 66.1001 21.2166 63.8089 22.6411 62.6847C24.4276 61.2749 25.6844 59.3634 26.2757 57.1572C26.5494 56.1367 27.5975 55.5301 28.6191 55.8041C29.6399 56.0775 30.2455 57.1266 29.9721 58.1475C29.1659 61.1563 27.4507 63.7637 25.012 65.6885C24.6609 65.9662 24.2429 66.1001 23.8277 66.1001Z"
                    fill="#21AC94" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M39.3459 77.0326C38.0978 77.0326 37.1686 75.8472 37.4965 74.6231C38.9462 69.2135 43.4523 65.1171 48.9768 64.1872C50.0186 64.0118 51.0059 64.7145 51.1813 65.7566C51.3567 66.7987 50.6541 67.7857 49.612 67.9611C45.5607 68.6434 42.256 71.6472 41.1933 75.614C40.9637 76.4688 40.1907 77.0326 39.3459 77.0326Z"
                    fill="#21AC94" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M52.8743 100.151C52.3846 100.151 51.895 99.9642 51.5212 99.5905C48.6175 96.6864 44.254 95.7366 40.4041 97.1724C39.4138 97.5411 38.3118 97.0382 37.9428 96.0475C37.5737 95.0576 38.077 93.9553 39.0673 93.5862C44.3154 91.6292 50.2668 92.9242 54.2267 96.8844C55.4353 98.0926 54.5639 100.151 52.8743 100.151Z"
                    fill="#21AC94" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M51.0921 85.501C49.4025 85.501 48.5308 83.4426 49.739 82.2344C53.6992 78.2742 59.6493 76.9799 64.8991 78.9363C65.8891 79.3054 66.3927 80.4076 66.0236 81.3976C65.6549 82.3876 64.552 82.8908 63.5623 82.5224C59.7124 81.0876 55.3493 82.0367 52.4451 84.9405C52.0714 85.3139 51.5817 85.501 51.0921 85.501Z"
                    fill="#21AC94" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M64.2348 45.1396C64.1292 45.1396 64.0225 45.131 63.9149 45.1127C58.3907 44.1829 53.8843 40.0865 52.4346 34.6766C52.1612 33.6557 52.7668 32.6066 53.7877 32.3329C54.8092 32.0604 55.8576 32.6654 56.1314 33.6859C57.1941 37.6528 60.4988 40.6565 64.5501 41.3386C66.8489 41.7256 66.5529 45.1396 64.2348 45.1396Z"
                    fill="#21AC94" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M73.9827 65.6007H64.2309C63.1741 65.6007 62.3174 64.7442 62.3174 63.6872C62.3174 62.6304 63.1741 61.7737 64.2309 61.7737H73.9827C75.0398 61.7737 75.8962 62.6304 75.8962 63.6872C75.8962 64.7439 75.0398 65.6007 73.9827 65.6007Z"
                    fill="#21AC94" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M77.7682 49.2067H64.2309C63.1741 49.2067 62.3174 48.3499 62.3174 47.2932C62.3174 46.2364 63.1741 45.3797 64.2309 45.3797H77.7682C79.5249 45.3797 80.954 43.9506 80.954 42.1939V37.8197C80.954 36.763 81.8104 35.9062 82.8675 35.9062C83.9246 35.9062 84.781 36.763 84.781 37.8197V42.1939C84.7807 46.0607 81.6347 49.2067 77.7682 49.2067Z"
                    fill="#21AC94" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M82.8675 91.7549C81.8104 91.7549 80.954 90.8985 80.954 89.8414V85.1766C80.954 83.4199 79.5249 81.9908 77.7682 81.9908H64.2309C63.1741 81.9908 62.3174 81.1344 62.3174 80.0773C62.3174 79.0202 63.1741 78.1638 64.2309 78.1638H77.7682C81.635 78.1638 84.7806 81.3098 84.7806 85.1763V89.8411C84.781 90.8985 83.9246 91.7549 82.8675 91.7549Z"
                    fill="#21AC94" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M82.8675 39.7344C79.2757 39.7344 76.3533 36.8124 76.3533 33.2202C76.3533 29.6281 79.2757 26.7061 82.8675 26.7061C86.4593 26.7061 89.3817 29.6281 89.3817 33.2202C89.382 36.8124 86.4596 39.7344 82.8675 39.7344ZM82.8675 30.5327C81.3855 30.5327 80.18 31.7383 80.18 33.2202C80.18 34.7022 81.3855 35.9074 82.8675 35.9074C84.3495 35.9074 85.555 34.7019 85.555 33.2202C85.555 31.7386 84.3495 30.5327 82.8675 30.5327Z"
                    fill="#21AC94" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M82.8675 100.959C79.2757 100.959 76.3533 98.0361 76.3533 94.4444C76.3533 90.8526 79.2757 87.9302 82.8675 87.9302C86.4593 87.9302 89.3817 90.8526 89.3817 94.4444C89.3817 98.0361 86.4596 100.959 82.8675 100.959ZM82.8675 91.7568C81.3855 91.7568 80.18 92.9624 80.18 94.4444C80.18 95.9263 81.3855 97.1319 82.8675 97.1319C84.3495 97.1319 85.555 95.9263 85.555 94.4444C85.555 92.9624 84.3495 91.7568 82.8675 91.7568Z"
                    fill="#21AC94" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M78.5854 70.2007C74.9936 70.2007 72.0712 67.2783 72.0712 63.6865C72.0712 60.0948 74.9936 57.1724 78.5854 57.1724C82.1772 57.1724 85.0996 60.0944 85.0996 63.6865C85.0996 67.279 82.1772 70.2007 78.5854 70.2007ZM78.5854 60.999C77.1034 60.999 75.8979 62.2046 75.8979 63.6862C75.8979 65.1682 77.1034 66.3737 78.5854 66.3737C80.0674 66.3737 81.2729 65.1682 81.2729 63.6862C81.2729 62.2046 80.0674 60.999 78.5854 60.999Z"
                    fill="#21AC94" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M123.549 65.7452H104.229C103.172 65.7452 102.315 64.8884 102.315 63.8317C102.315 62.775 103.172 61.9182 104.229 61.9182H123.549C124.606 61.9182 125.462 62.775 125.462 63.8317C125.462 64.8884 124.606 65.7452 123.549 65.7452Z"
                    fill="#21AC94" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M99.6294 70.3456C96.0376 70.3456 93.1152 67.4232 93.1152 63.8311C93.1152 60.2393 96.0376 57.3169 99.6294 57.3169C103.221 57.3169 106.143 60.239 106.143 63.8311C106.144 67.4232 103.222 70.3456 99.6294 70.3456ZM99.6294 61.1435C98.1475 61.1435 96.9419 62.3491 96.9419 63.8307C96.9419 65.3124 98.1475 66.5183 99.6294 66.5183C101.111 66.5183 102.317 65.3124 102.317 63.8307C102.317 62.3491 101.111 61.1435 99.6294 61.1435Z"
                    fill="#21AC94" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M80.4861 115.994C70.4692 115.994 62.3196 107.845 62.3196 97.827V29.8348C62.3196 19.8179 70.4692 11.668 80.4861 11.668C88.5793 11.668 95.5446 16.8842 97.86 24.509C109.337 26.549 117.1 37.4343 115.339 48.9498C121.455 51.9825 125.464 58.3399 125.464 65.2421C125.464 71.9752 121.745 78.1133 115.877 81.258C116.936 92.7226 108.77 103.032 97.3568 104.575C94.6157 111.455 87.9873 115.994 80.4861 115.994ZM80.4861 15.4953C72.579 15.4953 66.1466 21.9281 66.1466 29.8352V97.8276C66.1466 105.735 72.579 112.168 80.4861 112.168C86.7432 112.168 92.2309 108.168 94.141 102.215C94.3789 101.473 95.0426 100.95 95.819 100.891C106.031 100.122 113.574 90.7583 111.918 80.4414C111.78 79.5803 112.241 78.7345 113.04 78.3854C118.263 76.0995 121.638 70.941 121.638 65.2428C121.638 59.3681 117.958 53.994 112.482 51.8696C111.596 51.5257 111.096 50.5833 111.31 49.6568C112.437 44.7534 111.416 39.5834 108.509 35.4723C105.609 31.3696 101.092 28.6901 96.117 28.121C95.3094 28.0287 94.6483 27.4363 94.4682 26.6437C92.9776 20.0797 87.2275 15.4953 80.4861 15.4953Z"
                    fill="#0C0C0D" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M107.299 83.4085C106.242 83.4085 105.385 82.5521 105.385 81.495C105.385 80.438 106.242 79.5815 107.299 79.5815C109.304 79.5815 111.243 79.1759 113.063 78.3763C114.03 77.9517 115.159 78.3906 115.585 79.3583C116.009 80.3257 115.57 81.4548 114.603 81.88C112.295 82.8943 109.837 83.4085 107.299 83.4085Z"
                    fill="#0C0C0D" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M110.721 57.9348C109.24 57.9348 108.3 56.2924 109.099 55.0091C110.133 53.3481 110.879 51.5415 111.315 49.639C111.55 48.6088 112.576 47.9647 113.606 48.2009C114.637 48.4368 115.28 49.4629 115.045 50.4931C114.514 52.8102 113.607 55.0104 112.347 57.0325C111.985 57.6149 111.36 57.9348 110.721 57.9348Z"
                    fill="#0C0C0D" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M93.9222 36.6544C92.4442 36.6544 91.5034 35.0199 92.2954 33.7363C93.6853 31.483 94.4202 28.8841 94.4202 26.2209C94.4202 25.1641 95.2766 24.3074 96.3337 24.3074C97.3907 24.3074 98.2471 25.1641 98.2471 26.2209C98.2471 29.5941 97.3153 32.8879 95.553 35.7455C95.1909 36.3315 94.564 36.6544 93.9222 36.6544Z"
                    fill="#0C0C0D" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M95.9643 104.713C94.7169 104.713 93.7884 103.529 94.1143 102.306C95.0198 98.9084 94.8282 95.3923 93.5601 92.1381C93.1768 91.1534 93.6638 90.0442 94.6484 89.6605C95.6324 89.2765 96.7423 89.7642 97.126 90.7488C98.691 94.7661 98.9282 99.1034 97.8117 103.292C97.5838 104.148 96.8101 104.713 95.9643 104.713Z"
                    fill="#0C0C0D" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M47.9794 115.993C40.4786 115.993 33.8498 111.455 31.1085 104.575C19.6956 103.032 11.5291 92.7226 12.5885 81.258C6.72008 78.1133 3.00073 71.9752 3.00073 65.2421C3.00073 58.3399 7.01076 51.9825 13.127 48.9498C11.3659 37.4343 19.1279 26.549 30.6052 24.509C32.9203 16.8842 39.8856 11.668 47.9788 11.668C57.996 11.668 66.1456 19.8176 66.1456 29.8349V97.8273C66.1463 107.844 57.9964 115.993 47.9794 115.993ZM47.9794 15.495C41.2377 15.495 35.4876 20.0794 33.9966 26.6434C33.8166 27.436 33.1558 28.0283 32.3483 28.1207C27.3735 28.6897 22.8569 31.3693 19.9557 35.472C17.049 39.583 16.0284 44.7531 17.1556 49.6564C17.3685 50.583 16.8689 51.5251 15.9829 51.8692C10.5069 53.9937 6.82772 59.3681 6.82772 65.2424C6.82772 70.9404 10.2022 76.0992 15.4248 78.3851C16.2238 78.7345 16.6852 79.5803 16.547 80.4411C14.8906 90.754 22.429 100.119 32.6462 100.891C33.4226 100.95 34.0863 101.473 34.3242 102.214C36.235 108.167 41.7227 112.167 47.9791 112.167C55.8862 112.167 62.319 105.734 62.319 97.8273V29.8345C62.319 21.9277 55.8865 15.495 47.9794 15.495Z"
                    fill="#0C0C0D" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M21.1671 83.4083C18.628 83.4083 16.1707 82.8941 13.8636 81.8799C12.8962 81.4546 12.4567 80.3255 12.8819 79.3581C13.3071 78.3907 14.4366 77.9519 15.4037 78.3761C17.2228 79.1757 19.1619 79.5813 21.1674 79.5813C22.2241 79.5813 23.0809 80.4378 23.0809 81.4948C23.0812 82.5519 22.2241 83.4083 21.1671 83.4083Z"
                    fill="#0C0C0D" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M17.7454 57.9343C17.1066 57.9343 16.482 57.6144 16.1193 57.0324C14.8596 55.01 13.952 52.8098 13.4218 50.493C13.1859 49.4628 13.8301 48.4366 14.8602 48.2008C15.8884 47.9649 16.9166 48.6091 17.1524 49.6392C17.5879 51.5414 18.3331 53.3479 19.3679 55.0093C20.1662 56.2909 19.2294 57.9343 17.7454 57.9343Z"
                    fill="#0C0C0D" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M34.5419 36.6523C33.9001 36.6523 33.2732 36.3294 32.9115 35.743C31.1488 32.8854 30.2173 29.5916 30.2173 26.2184C30.2173 25.1617 31.074 24.3049 32.1308 24.3049C33.1875 24.3049 34.0443 25.1617 34.0443 26.2184C34.0443 28.8817 34.7791 31.4805 36.169 33.7339C36.961 35.0182 36.0199 36.6523 34.5419 36.6523Z"
                    fill="#0C0C0D" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M32.5004 104.713C31.6546 104.713 30.8809 104.148 30.6527 103.292C29.5365 99.1034 29.7737 94.7659 31.3387 90.7485C31.7224 89.7639 32.8316 89.2769 33.8163 89.6602C34.8009 90.0439 35.2883 91.1532 34.9046 92.1378C33.6365 95.3927 33.4449 98.9088 34.3504 102.306C34.6763 103.529 33.7465 104.713 32.5004 104.713Z"
                    fill="#0C0C0D" />
                </svg>
              </div>
              <h5>Adaptive Learning</h5>
              <p>At our daycare, we firmly believe that every child deserves a safe, nurturing, and enjoyable
                environment where they can learnotch early childhood education.</p>
            </div>
          </div>
          <div class="col-lg-3 col-md-6 wow fadeInUp animated" data-wow-delay="750ms">
            <div class="learn-block">
              <div class="svg">
                <svg xmlns="http://www.w3.org/2000/svg" width="128" height="128" viewBox="0 0 128 128" fill="none">
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M28.4699 40.3499L6.82203 40.3181C6.02732 40.3181 5.29619 39.7777 5.07367 39.0148C4.85115 38.2518 5.13725 37.4254 5.8048 36.9485L27.4527 22.4848C28.2792 21.9126 29.4236 22.1351 29.9958 22.9934C30.568 23.8199 30.3455 24.9643 29.4872 25.5365L12.83 36.6624L28.4699 36.6942C29.4872 36.6942 30.3137 37.5207 30.3137 38.5379C30.3137 39.5234 29.4872 40.3499 28.4699 40.3499Z"
                    fill="#21AC94" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M47.8616 95.5669C47.3847 95.5669 46.9397 95.3762 46.59 95.0265L27.1991 75.8899C26.8494 75.5402 26.6587 75.0634 26.6587 74.5548C26.6587 74.0462 26.8812 73.5693 27.2309 73.2515L59.8458 42.5121C60.5769 41.8127 61.7531 41.8445 62.4206 42.5756C63.12 43.3068 63.0882 44.483 62.3571 45.1505L31.1091 74.5866L49.1331 92.3881C49.8642 93.0874 49.8642 94.2636 49.1649 94.9629C48.7834 95.3762 48.3384 95.5669 47.8616 95.5669Z"
                    fill="#0C0C0D" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M28.4714 76.3976C27.4542 76.3976 26.6277 75.5711 26.6277 74.5539V24.0103C26.6277 23.0885 27.2952 22.3255 28.1853 22.1984C29.0754 22.0712 29.9337 22.6116 30.188 23.5017L41.8225 63.1101C42.1086 64.0955 41.5364 65.1127 40.5828 65.367C39.5974 65.6531 38.5801 65.0809 38.3258 64.1273L30.2834 36.7257V74.5539C30.3151 75.6029 29.4886 76.3976 28.4714 76.3976Z"
                    fill="#0C0C0D" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M115.795 101.16H58.1303C57.1131 101.16 56.2866 100.333 56.2866 99.3161C56.2866 98.2989 57.1131 97.4724 58.1303 97.4724H107.116L86.9624 88.5399C86.0406 88.1266 85.6273 87.0458 86.0406 86.1239C86.4538 85.2021 87.5346 84.7888 88.4565 85.2021L116.526 97.6313C117.32 97.981 117.765 98.8393 117.575 99.6976C117.384 100.556 116.653 101.16 115.795 101.16Z"
                    fill="#0C0C0D" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M44.8738 106.756C44.4287 106.756 44.0155 106.597 43.6658 106.311C43.1254 105.866 42.9347 105.135 43.0936 104.467L59.3057 43.4016C59.4329 42.8612 59.8143 42.4161 60.3229 42.1936C60.8315 41.9711 61.4037 41.9711 61.8806 42.2254L121.134 71.5661C121.77 71.884 122.183 72.5516 122.151 73.2509C122.12 73.982 121.706 74.6178 121.039 74.8721L45.5731 106.597C45.3506 106.692 45.1281 106.756 44.8738 106.756ZM62.2938 46.4851L47.6076 101.797L115.953 73.092L62.2938 46.4851Z"
                    fill="#21AC94" />
                </svg>
              </div>
              <h5>Creative Crafting</h5>
              <p>At our daycare, we firmly believe that every child deserves a safe, nurturing, and enjoyable
                environment where they can learnotch early childhood education.</p>
            </div>
          </div>
          <div class="col-lg-3 col-md-6 wow fadeInUp animated" data-wow-delay="900ms">
            <div class="learn-block">
              <div class="svg">
                <svg xmlns="http://www.w3.org/2000/svg" width="128" height="128" viewBox="0 0 128 128" fill="none">
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M38.325 52.1483C33.0692 52.1483 28.4715 48.698 27.0985 43.5728C26.8251 42.5519 27.4307 41.5028 28.4515 41.2291C29.4727 40.956 30.5215 41.5616 30.7952 42.5821C32.4476 48.7455 40.4355 50.376 44.3731 45.3866C45.0278 44.5568 46.2307 44.4152 47.0606 45.07C47.8901 45.7248 48.0316 46.928 47.3772 47.7575C45.1554 50.5723 41.828 52.1483 38.325 52.1483Z"
                    fill="#21AC94" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M23.8277 66.1001C22.0248 66.1001 21.2166 63.8089 22.6411 62.6847C24.4276 61.2749 25.6844 59.3634 26.2757 57.1572C26.5494 56.1367 27.5975 55.5301 28.6191 55.8041C29.6399 56.0775 30.2455 57.1266 29.9721 58.1475C29.1659 61.1563 27.4507 63.7637 25.012 65.6885C24.6609 65.9662 24.2429 66.1001 23.8277 66.1001Z"
                    fill="#21AC94" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M39.3459 77.0326C38.0978 77.0326 37.1686 75.8472 37.4965 74.6231C38.9462 69.2135 43.4523 65.1171 48.9768 64.1872C50.0186 64.0118 51.0059 64.7145 51.1813 65.7566C51.3567 66.7987 50.6541 67.7857 49.612 67.9611C45.5607 68.6434 42.256 71.6472 41.1933 75.614C40.9637 76.4688 40.1907 77.0326 39.3459 77.0326Z"
                    fill="#21AC94" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M52.8743 100.151C52.3846 100.151 51.895 99.9642 51.5212 99.5905C48.6175 96.6864 44.254 95.7366 40.4041 97.1724C39.4138 97.5411 38.3118 97.0382 37.9428 96.0475C37.5737 95.0576 38.077 93.9553 39.0673 93.5862C44.3154 91.6292 50.2668 92.9242 54.2267 96.8844C55.4353 98.0926 54.5639 100.151 52.8743 100.151Z"
                    fill="#21AC94" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M51.0921 85.501C49.4025 85.501 48.5308 83.4426 49.739 82.2344C53.6992 78.2742 59.6493 76.9799 64.8991 78.9363C65.8891 79.3054 66.3927 80.4076 66.0236 81.3976C65.6549 82.3876 64.552 82.8908 63.5623 82.5224C59.7124 81.0876 55.3493 82.0367 52.4451 84.9405C52.0714 85.3139 51.5817 85.501 51.0921 85.501Z"
                    fill="#21AC94" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M64.2348 45.1396C64.1292 45.1396 64.0225 45.131 63.9149 45.1127C58.3907 44.1829 53.8843 40.0865 52.4346 34.6766C52.1612 33.6557 52.7668 32.6066 53.7877 32.3329C54.8092 32.0604 55.8576 32.6654 56.1314 33.6859C57.1941 37.6528 60.4988 40.6565 64.5501 41.3386C66.8489 41.7256 66.5529 45.1396 64.2348 45.1396Z"
                    fill="#21AC94" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M73.9827 65.6007H64.2309C63.1741 65.6007 62.3174 64.7442 62.3174 63.6872C62.3174 62.6304 63.1741 61.7737 64.2309 61.7737H73.9827C75.0398 61.7737 75.8962 62.6304 75.8962 63.6872C75.8962 64.7439 75.0398 65.6007 73.9827 65.6007Z"
                    fill="#21AC94" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M77.7682 49.2067H64.2309C63.1741 49.2067 62.3174 48.3499 62.3174 47.2932C62.3174 46.2364 63.1741 45.3797 64.2309 45.3797H77.7682C79.5249 45.3797 80.954 43.9506 80.954 42.1939V37.8197C80.954 36.763 81.8104 35.9062 82.8675 35.9062C83.9246 35.9062 84.781 36.763 84.781 37.8197V42.1939C84.7807 46.0607 81.6347 49.2067 77.7682 49.2067Z"
                    fill="#21AC94" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M82.8675 91.7549C81.8104 91.7549 80.954 90.8985 80.954 89.8414V85.1766C80.954 83.4199 79.5249 81.9908 77.7682 81.9908H64.2309C63.1741 81.9908 62.3174 81.1344 62.3174 80.0773C62.3174 79.0202 63.1741 78.1638 64.2309 78.1638H77.7682C81.635 78.1638 84.7806 81.3098 84.7806 85.1763V89.8411C84.781 90.8985 83.9246 91.7549 82.8675 91.7549Z"
                    fill="#21AC94" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M82.8675 39.7344C79.2757 39.7344 76.3533 36.8124 76.3533 33.2202C76.3533 29.6281 79.2757 26.7061 82.8675 26.7061C86.4593 26.7061 89.3817 29.6281 89.3817 33.2202C89.382 36.8124 86.4596 39.7344 82.8675 39.7344ZM82.8675 30.5327C81.3855 30.5327 80.18 31.7383 80.18 33.2202C80.18 34.7022 81.3855 35.9074 82.8675 35.9074C84.3495 35.9074 85.555 34.7019 85.555 33.2202C85.555 31.7386 84.3495 30.5327 82.8675 30.5327Z"
                    fill="#21AC94" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M82.8675 100.959C79.2757 100.959 76.3533 98.0361 76.3533 94.4444C76.3533 90.8526 79.2757 87.9302 82.8675 87.9302C86.4593 87.9302 89.3817 90.8526 89.3817 94.4444C89.3817 98.0361 86.4596 100.959 82.8675 100.959ZM82.8675 91.7568C81.3855 91.7568 80.18 92.9624 80.18 94.4444C80.18 95.9263 81.3855 97.1319 82.8675 97.1319C84.3495 97.1319 85.555 95.9263 85.555 94.4444C85.555 92.9624 84.3495 91.7568 82.8675 91.7568Z"
                    fill="#21AC94" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M78.5854 70.2007C74.9936 70.2007 72.0712 67.2783 72.0712 63.6865C72.0712 60.0948 74.9936 57.1724 78.5854 57.1724C82.1772 57.1724 85.0996 60.0944 85.0996 63.6865C85.0996 67.279 82.1772 70.2007 78.5854 70.2007ZM78.5854 60.999C77.1034 60.999 75.8979 62.2046 75.8979 63.6862C75.8979 65.1682 77.1034 66.3737 78.5854 66.3737C80.0674 66.3737 81.2729 65.1682 81.2729 63.6862C81.2729 62.2046 80.0674 60.999 78.5854 60.999Z"
                    fill="#21AC94" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M123.549 65.7452H104.229C103.172 65.7452 102.315 64.8884 102.315 63.8317C102.315 62.775 103.172 61.9182 104.229 61.9182H123.549C124.606 61.9182 125.462 62.775 125.462 63.8317C125.462 64.8884 124.606 65.7452 123.549 65.7452Z"
                    fill="#21AC94" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M99.6294 70.3456C96.0376 70.3456 93.1152 67.4232 93.1152 63.8311C93.1152 60.2393 96.0376 57.3169 99.6294 57.3169C103.221 57.3169 106.143 60.239 106.143 63.8311C106.144 67.4232 103.222 70.3456 99.6294 70.3456ZM99.6294 61.1435C98.1475 61.1435 96.9419 62.3491 96.9419 63.8307C96.9419 65.3124 98.1475 66.5183 99.6294 66.5183C101.111 66.5183 102.317 65.3124 102.317 63.8307C102.317 62.3491 101.111 61.1435 99.6294 61.1435Z"
                    fill="#21AC94" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M80.4861 115.994C70.4692 115.994 62.3196 107.845 62.3196 97.827V29.8348C62.3196 19.8179 70.4692 11.668 80.4861 11.668C88.5793 11.668 95.5446 16.8842 97.86 24.509C109.337 26.549 117.1 37.4343 115.339 48.9498C121.455 51.9825 125.464 58.3399 125.464 65.2421C125.464 71.9752 121.745 78.1133 115.877 81.258C116.936 92.7226 108.77 103.032 97.3568 104.575C94.6157 111.455 87.9873 115.994 80.4861 115.994ZM80.4861 15.4953C72.579 15.4953 66.1466 21.9281 66.1466 29.8352V97.8276C66.1466 105.735 72.579 112.168 80.4861 112.168C86.7432 112.168 92.2309 108.168 94.141 102.215C94.3789 101.473 95.0426 100.95 95.819 100.891C106.031 100.122 113.574 90.7583 111.918 80.4414C111.78 79.5803 112.241 78.7345 113.04 78.3854C118.263 76.0995 121.638 70.941 121.638 65.2428C121.638 59.3681 117.958 53.994 112.482 51.8696C111.596 51.5257 111.096 50.5833 111.31 49.6568C112.437 44.7534 111.416 39.5834 108.509 35.4723C105.609 31.3696 101.092 28.6901 96.117 28.121C95.3094 28.0287 94.6483 27.4363 94.4682 26.6437C92.9776 20.0797 87.2275 15.4953 80.4861 15.4953Z"
                    fill="#0C0C0D" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M107.299 83.4085C106.242 83.4085 105.385 82.5521 105.385 81.495C105.385 80.438 106.242 79.5815 107.299 79.5815C109.304 79.5815 111.243 79.1759 113.063 78.3763C114.03 77.9517 115.159 78.3906 115.585 79.3583C116.009 80.3257 115.57 81.4548 114.603 81.88C112.295 82.8943 109.837 83.4085 107.299 83.4085Z"
                    fill="#0C0C0D" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M110.721 57.9348C109.24 57.9348 108.3 56.2924 109.099 55.0091C110.133 53.3481 110.879 51.5415 111.315 49.639C111.55 48.6088 112.576 47.9647 113.606 48.2009C114.637 48.4368 115.28 49.4629 115.045 50.4931C114.514 52.8102 113.607 55.0104 112.347 57.0325C111.985 57.6149 111.36 57.9348 110.721 57.9348Z"
                    fill="#0C0C0D" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M93.9222 36.6544C92.4442 36.6544 91.5034 35.0199 92.2954 33.7363C93.6853 31.483 94.4202 28.8841 94.4202 26.2209C94.4202 25.1641 95.2766 24.3074 96.3337 24.3074C97.3907 24.3074 98.2471 25.1641 98.2471 26.2209C98.2471 29.5941 97.3153 32.8879 95.553 35.7455C95.1909 36.3315 94.564 36.6544 93.9222 36.6544Z"
                    fill="#0C0C0D" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M95.9643 104.713C94.7169 104.713 93.7884 103.529 94.1143 102.306C95.0198 98.9084 94.8282 95.3923 93.5601 92.1381C93.1768 91.1534 93.6638 90.0442 94.6484 89.6605C95.6324 89.2765 96.7423 89.7642 97.126 90.7488C98.691 94.7661 98.9282 99.1034 97.8117 103.292C97.5838 104.148 96.8101 104.713 95.9643 104.713Z"
                    fill="#0C0C0D" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M47.9794 115.993C40.4786 115.993 33.8498 111.455 31.1085 104.575C19.6956 103.032 11.5291 92.7226 12.5885 81.258C6.72008 78.1133 3.00073 71.9752 3.00073 65.2421C3.00073 58.3399 7.01076 51.9825 13.127 48.9498C11.3659 37.4343 19.1279 26.549 30.6052 24.509C32.9203 16.8842 39.8856 11.668 47.9788 11.668C57.996 11.668 66.1456 19.8176 66.1456 29.8349V97.8273C66.1463 107.844 57.9964 115.993 47.9794 115.993ZM47.9794 15.495C41.2377 15.495 35.4876 20.0794 33.9966 26.6434C33.8166 27.436 33.1558 28.0283 32.3483 28.1207C27.3735 28.6897 22.8569 31.3693 19.9557 35.472C17.049 39.583 16.0284 44.7531 17.1556 49.6564C17.3685 50.583 16.8689 51.5251 15.9829 51.8692C10.5069 53.9937 6.82772 59.3681 6.82772 65.2424C6.82772 70.9404 10.2022 76.0992 15.4248 78.3851C16.2238 78.7345 16.6852 79.5803 16.547 80.4411C14.8906 90.754 22.429 100.119 32.6462 100.891C33.4226 100.95 34.0863 101.473 34.3242 102.214C36.235 108.167 41.7227 112.167 47.9791 112.167C55.8862 112.167 62.319 105.734 62.319 97.8273V29.8345C62.319 21.9277 55.8865 15.495 47.9794 15.495Z"
                    fill="#0C0C0D" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M21.1671 83.4083C18.628 83.4083 16.1707 82.8941 13.8636 81.8799C12.8962 81.4546 12.4567 80.3255 12.8819 79.3581C13.3071 78.3907 14.4366 77.9519 15.4037 78.3761C17.2228 79.1757 19.1619 79.5813 21.1674 79.5813C22.2241 79.5813 23.0809 80.4378 23.0809 81.4948C23.0812 82.5519 22.2241 83.4083 21.1671 83.4083Z"
                    fill="#0C0C0D" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M17.7454 57.9343C17.1066 57.9343 16.482 57.6144 16.1193 57.0324C14.8596 55.01 13.952 52.8098 13.4218 50.493C13.1859 49.4628 13.8301 48.4366 14.8602 48.2008C15.8884 47.9649 16.9166 48.6091 17.1524 49.6392C17.5879 51.5414 18.3331 53.3479 19.3679 55.0093C20.1662 56.2909 19.2294 57.9343 17.7454 57.9343Z"
                    fill="#0C0C0D" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M34.5419 36.6523C33.9001 36.6523 33.2732 36.3294 32.9115 35.743C31.1488 32.8854 30.2173 29.5916 30.2173 26.2184C30.2173 25.1617 31.074 24.3049 32.1308 24.3049C33.1875 24.3049 34.0443 25.1617 34.0443 26.2184C34.0443 28.8817 34.7791 31.4805 36.169 33.7339C36.961 35.0182 36.0199 36.6523 34.5419 36.6523Z"
                    fill="#0C0C0D" />
                  <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M32.5004 104.713C31.6546 104.713 30.8809 104.148 30.6527 103.292C29.5365 99.1034 29.7737 94.7659 31.3387 90.7485C31.7224 89.7639 32.8316 89.2769 33.8163 89.6602C34.8009 90.0439 35.2883 91.1532 34.9046 92.1378C33.6365 95.3927 33.4449 98.9088 34.3504 102.306C34.6763 103.529 33.7465 104.713 32.5004 104.713Z"
                    fill="#0C0C0D" />
                </svg>
              </div>
              <h5>Adaptive Learning</h5>
              <p>At our daycare, we firmly believe that every child deserves a safe, nurturing, and enjoyable
                environment where they can learnotch early childhood education.</p>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- What They Learn Section End -->

    <!-- Service Section Start -->
    <section class="service-sec mb-120">
      <div class="container-fluid">
        <div class="heading mb-48 wow fadeInUp animated" data-wow-delay="300ms">
          <div>
            <h2 class="mb-16">What we <span class="color-sec">Offer?</span></h2>
            <p>At our daycare, we firmly believe that every child deserves a safe, nurturing, and enjoyable environmen.
            </p>
          </div>
          <div>
            <a href="services.php" class="cus-btn">
              <span class="icon">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                  <g clip-path="url(#clip0_13590_1786)">
                    <path
                      d="M15.2478 0.439753C15.1203 0.312229 14.9291 0.273016 14.7618 0.339963L0.278578 6.13316C0.112863 6.19945 0.00189545 6.35726 -0.00447473 6.53565C-0.0108149 6.71402 0.0887042 6.87931 0.249281 6.9572L5.96045 9.72705L8.73033 15.4382C8.80587 15.594 8.96363 15.6923 9.13577 15.6923C9.14112 15.6923 9.1465 15.6922 9.15188 15.692C9.33021 15.6856 9.48809 15.5747 9.55434 15.409L15.3476 0.92587C15.4145 0.758442 15.3753 0.567246 15.2478 0.439753ZM1.56055 6.59127L13.0577 1.99245L6.20588 8.84421L1.56055 6.59127ZM9.09626 14.127L6.84329 9.48159L13.6951 2.62983L9.09626 14.127Z"
                      fill="#F7B631" />
                  </g>
                  <defs>
                    <clipPath>
                      <rect width="15.3846" height="15.3846" fill="white" transform="translate(-0.00463867 0.307693)" />
                    </clipPath>
                  </defs>
                </svg>
              </span>
              <span class="text">Discover More</span>
            </a>
          </div>
        </div>
        <div class="row row-gap-4">
          <div class="col-xxl-3 col-lg-4 col-md-6 wow fadeInUp animated" data-wow-delay="400ms">
            <div class="service-card">
              <a href="service-detail.php" class="card-img">
                <img src="assets/media/services/img-1.webp" alt="img-1">
              </a>
              <div>
                <div class="text-center">
                  <a href="service-detail.php" class="h5 mb-16 hover-content">Playing Fun Games</a>
                  <p class="mb-24">At our daycare, we firmly believe that every child deserves a safe, nurturing, and
                    enjoyable environmen.</p>
                </div>
                <div class="b-bottom mb-24"></div>
                <div class="d-flex align-items-center justify-content-between">
                  <div class="d-flex align-items-center gap-8">
                    <svg class="svg" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                      fill="none">
                      <path
                        d="M22 21V19C22 17.1362 20.7252 15.5701 19 15.126M15.5 3.29076C16.9659 3.88415 18 5.32131 18 7C18 8.67869 16.9659 10.1159 15.5 10.7092M17 21C17 19.1362 17 18.2044 16.6955 17.4693C16.2895 16.4892 15.5108 15.7105 14.5307 15.3045C13.7956 15 12.8638 15 11 15H8C6.13623 15 5.20435 15 4.46927 15.3045C3.48915 15.7105 2.71046 16.4892 2.30448 17.4693C2 18.2044 2 19.1362 2 21M13.5 7C13.5 9.20914 11.7091 11 9.5 11C7.29086 11 5.5 9.20914 5.5 7C5.5 4.79086 7.29086 3 9.5 3C11.7091 3 13.5 4.79086 13.5 7Z"
                        stroke="#F7B631" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                    </svg>
                    <p class="black">2-5 Yo</p>
                  </div>
                  <div class="vr-line"></div>
                  <div class="d-flex align-items-center gap-8">
                    <svg class="svg" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                      fill="none">
                      <path
                        d="M9 21V13.6C9 13.0399 9 12.7599 9.10899 12.546C9.20487 12.3578 9.35785 12.2049 9.54601 12.109C9.75992 12 10.0399 12 10.6 12H13.4C13.9601 12 14.2401 12 14.454 12.109C14.6422 12.2049 14.7951 12.3578 14.891 12.546C15 12.7599 15 13.0399 15 13.6V21M11.0177 2.764L4.23539 8.03912C3.78202 8.39175 3.55534 8.56806 3.39203 8.78886C3.24737 8.98444 3.1396 9.20478 3.07403 9.43905C3 9.70352 3 9.9907 3 10.5651V17.8C3 18.9201 3 19.4801 3.21799 19.908C3.40973 20.2843 3.71569 20.5903 4.09202 20.782C4.51984 21 5.07989 21 6.2 21H17.8C18.9201 21 19.4802 21 19.908 20.782C20.2843 20.5903 20.5903 20.2843 20.782 19.908C21 19.4801 21 18.9201 21 17.8V10.5651C21 9.9907 21 9.70352 20.926 9.43905C20.8604 9.20478 20.7526 8.98444 20.608 8.78886C20.4447 8.56806 20.218 8.39175 19.7646 8.03913L12.9823 2.764C12.631 2.49075 12.4553 2.35412 12.2613 2.3016C12.0902 2.25526 11.9098 2.25526 11.7387 2.3016C11.5447 2.35412 11.369 2.49075 11.0177 2.764Z"
                        stroke="#F7B631" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                    </svg>
                    <p class="black">15 Seats</p>
                  </div>
                  <div class="vr-line"></div>
                  <div class="d-flex align-items-center gap-8">
                    <svg class="svg" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                      fill="none">
                      <path
                        d="M17 14.5001V11.4945C17 11.315 17 11.2253 16.9727 11.146C16.9485 11.076 16.9091 11.0122 16.8572 10.9592C16.7986 10.8993 16.7183 10.8592 16.5578 10.779L12 8.50006M4 9.50006V16.3067C4 16.6786 4 16.8645 4.05802 17.0274C4.10931 17.1713 4.1929 17.3016 4.30238 17.4082C4.42622 17.5287 4.59527 17.6062 4.93335 17.7612L11.3334 20.6945C11.5786 20.8069 11.7012 20.8631 11.8289 20.8853C11.9421 20.9049 12.0579 20.9049 12.1711 20.8853C12.2988 20.8631 12.4214 20.8069 12.6666 20.6945L19.0666 17.7612C19.4047 17.6062 19.5738 17.5287 19.6976 17.4082C19.8071 17.3016 19.8907 17.1713 19.942 17.0274C20 16.8645 20 16.6786 20 16.3067V9.50006M2 8.50006L11.6422 3.67895C11.7734 3.61336 11.839 3.58056 11.9078 3.56766C11.9687 3.55622 12.0313 3.55622 12.0922 3.56766C12.161 3.58056 12.2266 3.61336 12.3578 3.67895L22 8.50006L12.3578 13.3212C12.2266 13.3868 12.161 13.4196 12.0922 13.4325C12.0313 13.4439 11.9687 13.4439 11.9078 13.4325C11.839 13.4196 11.7734 13.3868 11.6422 13.3212L2 8.50006Z"
                        stroke="#F7B631" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                    </svg>
                    <p class="black">$20/Hr</p>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="col-xxl-3 col-lg-4 col-md-6 wow fadeInUp animated" data-wow-delay="550ms">
            <div class="service-card">
              <a href="service-detail.php" class="card-img">
                <img src="assets/media/services/img-2.webp" alt="img-1">
              </a>
              <div>
                <div class="text-center">
                  <a href="service-detail.php" class="h5 mb-16 hover-content">Play & Learn</a>
                  <p class="mb-24">At our daycare, we firmly believe that every child deserves a safe, nurturing, and
                    enjoyable environmen.</p>
                </div>
                <div class="b-bottom mb-24"></div>
                <div class="d-flex align-items-center justify-content-between">
                  <div class="d-flex align-items-center gap-8">
                    <svg class="svg" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                      fill="none">
                      <path
                        d="M22 21V19C22 17.1362 20.7252 15.5701 19 15.126M15.5 3.29076C16.9659 3.88415 18 5.32131 18 7C18 8.67869 16.9659 10.1159 15.5 10.7092M17 21C17 19.1362 17 18.2044 16.6955 17.4693C16.2895 16.4892 15.5108 15.7105 14.5307 15.3045C13.7956 15 12.8638 15 11 15H8C6.13623 15 5.20435 15 4.46927 15.3045C3.48915 15.7105 2.71046 16.4892 2.30448 17.4693C2 18.2044 2 19.1362 2 21M13.5 7C13.5 9.20914 11.7091 11 9.5 11C7.29086 11 5.5 9.20914 5.5 7C5.5 4.79086 7.29086 3 9.5 3C11.7091 3 13.5 4.79086 13.5 7Z"
                        stroke="#F7B631" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                    </svg>
                    <p class="black">5-8 Yo</p>
                  </div>
                  <div class="vr-line"></div>
                  <div class="d-flex align-items-center gap-8">
                    <svg class="svg" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                      fill="none">
                      <path
                        d="M9 21V13.6C9 13.0399 9 12.7599 9.10899 12.546C9.20487 12.3578 9.35785 12.2049 9.54601 12.109C9.75992 12 10.0399 12 10.6 12H13.4C13.9601 12 14.2401 12 14.454 12.109C14.6422 12.2049 14.7951 12.3578 14.891 12.546C15 12.7599 15 13.0399 15 13.6V21M11.0177 2.764L4.23539 8.03912C3.78202 8.39175 3.55534 8.56806 3.39203 8.78886C3.24737 8.98444 3.1396 9.20478 3.07403 9.43905C3 9.70352 3 9.9907 3 10.5651V17.8C3 18.9201 3 19.4801 3.21799 19.908C3.40973 20.2843 3.71569 20.5903 4.09202 20.782C4.51984 21 5.07989 21 6.2 21H17.8C18.9201 21 19.4802 21 19.908 20.782C20.2843 20.5903 20.5903 20.2843 20.782 19.908C21 19.4801 21 18.9201 21 17.8V10.5651C21 9.9907 21 9.70352 20.926 9.43905C20.8604 9.20478 20.7526 8.98444 20.608 8.78886C20.4447 8.56806 20.218 8.39175 19.7646 8.03913L12.9823 2.764C12.631 2.49075 12.4553 2.35412 12.2613 2.3016C12.0902 2.25526 11.9098 2.25526 11.7387 2.3016C11.5447 2.35412 11.369 2.49075 11.0177 2.764Z"
                        stroke="#F7B631" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                    </svg>
                    <p class="black">18 Seats</p>
                  </div>
                  <div class="vr-line"></div>
                  <div class="d-flex align-items-center gap-8">
                    <svg class="svg" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                      fill="none">
                      <path
                        d="M17 14.5001V11.4945C17 11.315 17 11.2253 16.9727 11.146C16.9485 11.076 16.9091 11.0122 16.8572 10.9592C16.7986 10.8993 16.7183 10.8592 16.5578 10.779L12 8.50006M4 9.50006V16.3067C4 16.6786 4 16.8645 4.05802 17.0274C4.10931 17.1713 4.1929 17.3016 4.30238 17.4082C4.42622 17.5287 4.59527 17.6062 4.93335 17.7612L11.3334 20.6945C11.5786 20.8069 11.7012 20.8631 11.8289 20.8853C11.9421 20.9049 12.0579 20.9049 12.1711 20.8853C12.2988 20.8631 12.4214 20.8069 12.6666 20.6945L19.0666 17.7612C19.4047 17.6062 19.5738 17.5287 19.6976 17.4082C19.8071 17.3016 19.8907 17.1713 19.942 17.0274C20 16.8645 20 16.6786 20 16.3067V9.50006M2 8.50006L11.6422 3.67895C11.7734 3.61336 11.839 3.58056 11.9078 3.56766C11.9687 3.55622 12.0313 3.55622 12.0922 3.56766C12.161 3.58056 12.2266 3.61336 12.3578 3.67895L22 8.50006L12.3578 13.3212C12.2266 13.3868 12.161 13.4196 12.0922 13.4325C12.0313 13.4439 11.9687 13.4439 11.9078 13.4325C11.839 13.4196 11.7734 13.3868 11.6422 13.3212L2 8.50006Z"
                        stroke="#F7B631" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                    </svg>
                    <p class="black">$30/Hr</p>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="col-xxl-3 col-lg-4 col-md-6 wow fadeInUp animated" data-wow-delay="750ms">
            <div class="service-card">
              <a href="service-detail.php" class="card-img">
                <img src="assets/media/services/img-3.webp" alt="img-1">
              </a>
              <div>
                <div class="text-center">
                  <a href="service-detail.php" class="h5 mb-16 hover-content">Tiny Adventures</a>
                  <p class="mb-24">At our daycare, we firmly believe that every child deserves a safe, nurturing, and
                    enjoyable environmen.</p>
                </div>
                <div class="b-bottom mb-24"></div>
                <div class="d-flex align-items-center justify-content-between">
                  <div class="d-flex align-items-center gap-8">
                    <svg class="svg" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                      fill="none">
                      <path
                        d="M22 21V19C22 17.1362 20.7252 15.5701 19 15.126M15.5 3.29076C16.9659 3.88415 18 5.32131 18 7C18 8.67869 16.9659 10.1159 15.5 10.7092M17 21C17 19.1362 17 18.2044 16.6955 17.4693C16.2895 16.4892 15.5108 15.7105 14.5307 15.3045C13.7956 15 12.8638 15 11 15H8C6.13623 15 5.20435 15 4.46927 15.3045C3.48915 15.7105 2.71046 16.4892 2.30448 17.4693C2 18.2044 2 19.1362 2 21M13.5 7C13.5 9.20914 11.7091 11 9.5 11C7.29086 11 5.5 9.20914 5.5 7C5.5 4.79086 7.29086 3 9.5 3C11.7091 3 13.5 4.79086 13.5 7Z"
                        stroke="#F7B631" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                    </svg>
                    <p class="black">8-12 Yo</p>
                  </div>
                  <div class="vr-line"></div>
                  <div class="d-flex align-items-center gap-8">
                    <svg class="svg" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                      fill="none">
                      <path
                        d="M9 21V13.6C9 13.0399 9 12.7599 9.10899 12.546C9.20487 12.3578 9.35785 12.2049 9.54601 12.109C9.75992 12 10.0399 12 10.6 12H13.4C13.9601 12 14.2401 12 14.454 12.109C14.6422 12.2049 14.7951 12.3578 14.891 12.546C15 12.7599 15 13.0399 15 13.6V21M11.0177 2.764L4.23539 8.03912C3.78202 8.39175 3.55534 8.56806 3.39203 8.78886C3.24737 8.98444 3.1396 9.20478 3.07403 9.43905C3 9.70352 3 9.9907 3 10.5651V17.8C3 18.9201 3 19.4801 3.21799 19.908C3.40973 20.2843 3.71569 20.5903 4.09202 20.782C4.51984 21 5.07989 21 6.2 21H17.8C18.9201 21 19.4802 21 19.908 20.782C20.2843 20.5903 20.5903 20.2843 20.782 19.908C21 19.4801 21 18.9201 21 17.8V10.5651C21 9.9907 21 9.70352 20.926 9.43905C20.8604 9.20478 20.7526 8.98444 20.608 8.78886C20.4447 8.56806 20.218 8.39175 19.7646 8.03913L12.9823 2.764C12.631 2.49075 12.4553 2.35412 12.2613 2.3016C12.0902 2.25526 11.9098 2.25526 11.7387 2.3016C11.5447 2.35412 11.369 2.49075 11.0177 2.764Z"
                        stroke="#F7B631" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                    </svg>
                    <p class="black">22 Seats</p>
                  </div>
                  <div class="vr-line"></div>
                  <div class="d-flex align-items-center gap-8">
                    <svg class="svg" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                      fill="none">
                      <path
                        d="M17 14.5001V11.4945C17 11.315 17 11.2253 16.9727 11.146C16.9485 11.076 16.9091 11.0122 16.8572 10.9592C16.7986 10.8993 16.7183 10.8592 16.5578 10.779L12 8.50006M4 9.50006V16.3067C4 16.6786 4 16.8645 4.05802 17.0274C4.10931 17.1713 4.1929 17.3016 4.30238 17.4082C4.42622 17.5287 4.59527 17.6062 4.93335 17.7612L11.3334 20.6945C11.5786 20.8069 11.7012 20.8631 11.8289 20.8853C11.9421 20.9049 12.0579 20.9049 12.1711 20.8853C12.2988 20.8631 12.4214 20.8069 12.6666 20.6945L19.0666 17.7612C19.4047 17.6062 19.5738 17.5287 19.6976 17.4082C19.8071 17.3016 19.8907 17.1713 19.942 17.0274C20 16.8645 20 16.6786 20 16.3067V9.50006M2 8.50006L11.6422 3.67895C11.7734 3.61336 11.839 3.58056 11.9078 3.56766C11.9687 3.55622 12.0313 3.55622 12.0922 3.56766C12.161 3.58056 12.2266 3.61336 12.3578 3.67895L22 8.50006L12.3578 13.3212C12.2266 13.3868 12.161 13.4196 12.0922 13.4325C12.0313 13.4439 11.9687 13.4439 11.9078 13.4325C11.839 13.4196 11.7734 13.3868 11.6422 13.3212L2 8.50006Z"
                        stroke="#F7B631" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                    </svg>
                    <p class="black">$31/Hr</p>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="col-xxl-3 col-lg-4 col-md-6 d-xxl-block d-lg-none wow fadeInUp animated" data-wow-delay="900ms">
            <div class="service-card">
              <a href="service-detail.php" class="card-img">
                <img src="assets/media/services/img-4.webp" alt="img-1">
              </a>
              <div>
                <div class="text-center">
                  <a href="service-detail.php" class="h5 mb-16 hover-content">Smart & Fun</a>
                  <p class="mb-24">At our daycare, we firmly believe that every child deserves a safe, nurturing, and
                    enjoyable environmen.</p>
                </div>
                <div class="b-bottom mb-24"></div>
                <div class="d-flex align-items-center justify-content-between">
                  <div class="d-flex align-items-center gap-8">
                    <svg class="svg" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                      fill="none">
                      <path
                        d="M22 21V19C22 17.1362 20.7252 15.5701 19 15.126M15.5 3.29076C16.9659 3.88415 18 5.32131 18 7C18 8.67869 16.9659 10.1159 15.5 10.7092M17 21C17 19.1362 17 18.2044 16.6955 17.4693C16.2895 16.4892 15.5108 15.7105 14.5307 15.3045C13.7956 15 12.8638 15 11 15H8C6.13623 15 5.20435 15 4.46927 15.3045C3.48915 15.7105 2.71046 16.4892 2.30448 17.4693C2 18.2044 2 19.1362 2 21M13.5 7C13.5 9.20914 11.7091 11 9.5 11C7.29086 11 5.5 9.20914 5.5 7C5.5 4.79086 7.29086 3 9.5 3C11.7091 3 13.5 4.79086 13.5 7Z"
                        stroke="#F7B631" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                    </svg>
                    <p class="black">2-5 Yo</p>
                  </div>
                  <div class="vr-line"></div>
                  <div class="d-flex align-items-center gap-8">
                    <svg class="svg" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                      fill="none">
                      <path
                        d="M9 21V13.6C9 13.0399 9 12.7599 9.10899 12.546C9.20487 12.3578 9.35785 12.2049 9.54601 12.109C9.75992 12 10.0399 12 10.6 12H13.4C13.9601 12 14.2401 12 14.454 12.109C14.6422 12.2049 14.7951 12.3578 14.891 12.546C15 12.7599 15 13.0399 15 13.6V21M11.0177 2.764L4.23539 8.03912C3.78202 8.39175 3.55534 8.56806 3.39203 8.78886C3.24737 8.98444 3.1396 9.20478 3.07403 9.43905C3 9.70352 3 9.9907 3 10.5651V17.8C3 18.9201 3 19.4801 3.21799 19.908C3.40973 20.2843 3.71569 20.5903 4.09202 20.782C4.51984 21 5.07989 21 6.2 21H17.8C18.9201 21 19.4802 21 19.908 20.782C20.2843 20.5903 20.5903 20.2843 20.782 19.908C21 19.4801 21 18.9201 21 17.8V10.5651C21 9.9907 21 9.70352 20.926 9.43905C20.8604 9.20478 20.7526 8.98444 20.608 8.78886C20.4447 8.56806 20.218 8.39175 19.7646 8.03913L12.9823 2.764C12.631 2.49075 12.4553 2.35412 12.2613 2.3016C12.0902 2.25526 11.9098 2.25526 11.7387 2.3016C11.5447 2.35412 11.369 2.49075 11.0177 2.764Z"
                        stroke="#F7B631" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                    </svg>
                    <p class="black">15 Seats</p>
                  </div>
                  <div class="vr-line"></div>
                  <div class="d-flex align-items-center gap-8">
                    <svg class="svg" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                      fill="none">
                      <path
                        d="M17 14.5001V11.4945C17 11.315 17 11.2253 16.9727 11.146C16.9485 11.076 16.9091 11.0122 16.8572 10.9592C16.7986 10.8993 16.7183 10.8592 16.5578 10.779L12 8.50006M4 9.50006V16.3067C4 16.6786 4 16.8645 4.05802 17.0274C4.10931 17.1713 4.1929 17.3016 4.30238 17.4082C4.42622 17.5287 4.59527 17.6062 4.93335 17.7612L11.3334 20.6945C11.5786 20.8069 11.7012 20.8631 11.8289 20.8853C11.9421 20.9049 12.0579 20.9049 12.1711 20.8853C12.2988 20.8631 12.4214 20.8069 12.6666 20.6945L19.0666 17.7612C19.4047 17.6062 19.5738 17.5287 19.6976 17.4082C19.8071 17.3016 19.8907 17.1713 19.942 17.0274C20 16.8645 20 16.6786 20 16.3067V9.50006M2 8.50006L11.6422 3.67895C11.7734 3.61336 11.839 3.58056 11.9078 3.56766C11.9687 3.55622 12.0313 3.55622 12.0922 3.56766C12.161 3.58056 12.2266 3.61336 12.3578 3.67895L22 8.50006L12.3578 13.3212C12.2266 13.3868 12.161 13.4196 12.0922 13.4325C12.0313 13.4439 11.9687 13.4439 11.9078 13.4325C11.839 13.4196 11.7734 13.3868 11.6422 13.3212L2 8.50006Z"
                        stroke="#F7B631" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                    </svg>
                    <p class="black">$20/Hr</p>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- Service Section End -->

    <!-- Banner Start -->
    <section class="banner-sec mb-120 wow fadeInUp animated" data-wow-delay="400ms">
      <div class="container-fluid">
        <div class="banner-wrapper">
          <div class="content">
            <h6 class="fw-500 white mb-16">Playing Fun Games</h6>
            <h3 class="mb-16 white">Playing Fun Games</h3>
            <p class="mb-48 white">At our daycare, we firmly believe that every child deserves a safe, nurturing, and
              enjoyable environment where they can learn, play, and grow. Our dedicated caregivers are not only trained
              professionals but also passionate individuals who deliver top-notch early childhood education. We focus on
              fostering creativity.</p>
            <div>
              <a href="services.php" class="cus-btn white-bg">
                <span class="icon">
                  <svg xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17" fill="none">
                    <g clip-path="url(#clip0_13565_483)">
                      <path
                        d="M15.8725 0.939654C15.745 0.81213 15.5537 0.772917 15.3864 0.839864L0.903211 6.63306C0.737497 6.69935 0.626529 6.85716 0.620159 7.03556C0.613819 7.21392 0.713338 7.37921 0.873915 7.4571L6.58508 10.227L9.35497 15.9381C9.43051 16.0939 9.58826 16.1922 9.76041 16.1922C9.76575 16.1922 9.77113 16.1921 9.77651 16.1919C9.95485 16.1855 10.1127 16.0746 10.179 15.9089L15.9722 1.42577C16.0392 1.25834 16 1.06715 15.8725 0.939654ZM2.18518 7.09117L13.6823 2.49235L6.83051 9.34412L2.18518 7.09117ZM9.72089 14.6269L7.46792 9.98149L14.3198 3.12973L9.72089 14.6269Z"
                        fill="#FAFAFA" />
                    </g>
                    <defs>
                      <clipPath>
                        <rect width="15.3846" height="15.3846" fill="white" transform="translate(0.619995 0.807617)" />
                      </clipPath>
                    </defs>
                  </svg>
                </span>
                <span class="text">Get Started</span>
              </a>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- Banner End -->

    <!-- Our Plan Section Start -->
    <section class="pricing-sec mb-120">
      <div class="container-fluid">
        <div class="text-center mb-48 wow fadeInUp animated" data-wow-delay="500ms">
          <h2 class="mb-16">Choose your <span class="color-primary"> plan</span></h2>
          <p>At our daycare, we firmly believe that every child deserves a safe, nurturing, and enjoyable environmen.
          </p>
        </div>
        <div class="row row-gap-4">
          <div class="col-lg-4 col-md-6 wow fadeInUp animated" data-wow-delay="300ms">
            <div class="pricing-card">
              <div class="topbar mb-32">
                <h4 class="white mb-26">Basic</h4>
                <p class="white">Fundamentals of the subject matter are essential for building a strong foundation.
                  Understanding the basic</p>
              </div>
              <div class="centerbar mb-32">
                <h4 class="color-sec mb-32">$29.00/m</h4>
                <div class="d-flex align-items-center gap-12 mb-16">
                  <svg class="tick-svg" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                    fill="none">
                    <path d="M20 6L9 17L4 12" stroke="#F7B631" stroke-width="2" stroke-linecap="round"
                      stroke-linejoin="round" />
                  </svg>
                  <p>Automated management</p>
                </div>
                <div class="d-flex align-items-center gap-12 mb-16">
                  <svg class="tick-svg" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                    fill="none">
                    <path d="M20 6L9 17L4 12" stroke="#F7B631" stroke-width="2" stroke-linecap="round"
                      stroke-linejoin="round" />
                  </svg>
                  <p>Bug Fixing</p>
                </div>
                <div class="d-flex align-items-center gap-12 mb-16">
                  <svg class="tick-svg" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                    fill="none">
                    <path d="M20 6L9 17L4 12" stroke="#F7B631" stroke-width="2" stroke-linecap="round"
                      stroke-linejoin="round" />
                  </svg>
                  <p>Agile Development</p>
                </div>
                <div class="d-flex align-items-center gap-12 mb-16">
                  <svg class="tick-svg" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                    fill="none">
                    <path d="M20 6L9 17L4 12" stroke="#F7B631" stroke-width="2" stroke-linecap="round"
                      stroke-linejoin="round" />
                  </svg>
                  <p>SOX compliance</p>
                </div>
                <div class="d-flex align-items-center gap-12 mb-16">
                  <svg class="tick-svg" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                    fill="none">
                    <path d="M20 6L9 17L4 12" stroke="#F7B631" stroke-width="2" stroke-linecap="round"
                      stroke-linejoin="round" />
                  </svg>
                  <p>Enterprise ERP integrations</p>
                </div>
                <div class="d-flex align-items-center gap-12 mb-16">
                  <svg class="tick-svg" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                    fill="none">
                    <path d="M20 6L9 17L4 12" stroke="#F7B631" stroke-width="2" stroke-linecap="round"
                      stroke-linejoin="round" />
                  </svg>
                  <p>Limited tools</p>
                </div>
                <div class="d-flex align-items-center gap-12">
                  <svg class="tick-svg" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                    fill="none">
                    <path d="M20 6L9 17L4 12" stroke="#F7B631" stroke-width="2" stroke-linecap="round"
                      stroke-linejoin="round" />
                  </svg>
                  <p>Local video issuance</p>
                </div>
              </div>
              <div class="bottom-bar">
                <a href="" class="cus-btn">
                  <span class="icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17" fill="none">
                      <g clip-path="url(#clip0_13565_558)">
                        <path
                          d="M15.8725 0.939654C15.745 0.81213 15.5538 0.772917 15.3864 0.839864L0.903272 6.63306C0.737558 6.69935 0.62659 6.85716 0.62022 7.03556C0.61388 7.21392 0.713399 7.37921 0.873976 7.4571L6.58514 10.227L9.35503 15.9381C9.43057 16.0939 9.58832 16.1922 9.76047 16.1922C9.76582 16.1922 9.77119 16.1921 9.77657 16.1919C9.95491 16.1855 10.1128 16.0746 10.179 15.9089L15.9723 1.42577C16.0392 1.25834 16 1.06715 15.8725 0.939654ZM2.18524 7.09117L13.6824 2.49235L6.83057 9.34412L2.18524 7.09117ZM9.72095 14.6269L7.46798 9.98149L14.3198 3.12973L9.72095 14.6269Z"
                          fill="#F7B631" />
                      </g>
                      <defs>
                        <clipPath>
                          <rect width="15.3846" height="15.3846" fill="white"
                            transform="translate(0.619995 0.807617)" />
                        </clipPath>
                      </defs>
                    </svg>
                  </span>
                  <span class="text">Get Started</span>
                </a>
              </div>
            </div>
          </div>
          <div class="col-lg-4 col-md-6 wow fadeInUp animated" data-wow-delay="450ms">
            <div class="pricing-card card-2">
              <div class="topbar mb-32">
                <h4 class="white mb-26">Standard</h4>
                <p class="white">Fundamentals of the subject matter are essential for building a strong foundation.
                  Understanding the basic</p>
              </div>
              <div class="centerbar mb-32">
                <h4 class="color-ter mb-32">$59.00/m</h4>
                <div class="d-flex align-items-center gap-12 mb-16">
                  <svg class="tick-svg" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                    fill="none">
                    <path d="M20 6L9 17L4 12" stroke="#F7B631" stroke-width="2" stroke-linecap="round"
                      stroke-linejoin="round" />
                  </svg>
                  <p>Automated management</p>
                </div>
                <div class="d-flex align-items-center gap-12 mb-16">
                  <svg class="tick-svg" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                    fill="none">
                    <path d="M20 6L9 17L4 12" stroke="#F7B631" stroke-width="2" stroke-linecap="round"
                      stroke-linejoin="round" />
                  </svg>
                  <p>Bug Fixing</p>
                </div>
                <div class="d-flex align-items-center gap-12 mb-16">
                  <svg class="tick-svg" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                    fill="none">
                    <path d="M20 6L9 17L4 12" stroke="#F7B631" stroke-width="2" stroke-linecap="round"
                      stroke-linejoin="round" />
                  </svg>
                  <p>Agile Development</p>
                </div>
                <div class="d-flex align-items-center gap-12 mb-16">
                  <svg class="tick-svg" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                    fill="none">
                    <path d="M20 6L9 17L4 12" stroke="#F7B631" stroke-width="2" stroke-linecap="round"
                      stroke-linejoin="round" />
                  </svg>
                  <p>SOX compliance</p>
                </div>
                <div class="d-flex align-items-center gap-12 mb-16">
                  <svg class="tick-svg" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                    fill="none">
                    <path d="M20 6L9 17L4 12" stroke="#F7B631" stroke-width="2" stroke-linecap="round"
                      stroke-linejoin="round" />
                  </svg>
                  <p>Enterprise ERP integrations</p>
                </div>
                <div class="d-flex align-items-center gap-12 mb-16">
                  <svg class="tick-svg" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                    fill="none">
                    <path d="M20 6L9 17L4 12" stroke="#F7B631" stroke-width="2" stroke-linecap="round"
                      stroke-linejoin="round" />
                  </svg>
                  <p>Limited tools</p>
                </div>
                <div class="d-flex align-items-center gap-12">
                  <svg class="tick-svg" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                    fill="none">
                    <path d="M20 6L9 17L4 12" stroke="#F7B631" stroke-width="2" stroke-linecap="round"
                      stroke-linejoin="round" />
                  </svg>
                  <p>Local video issuance</p>
                </div>
              </div>
              <div class="bottom-bar">
                <a href="" class="cus-btn">
                  <span class="icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17" fill="none">
                      <g clip-path="url(#clip0_13565_592)">
                        <path
                          d="M15.8725 0.939654C15.745 0.81213 15.5538 0.772917 15.3864 0.839864L0.903272 6.63306C0.737558 6.69935 0.62659 6.85716 0.62022 7.03556C0.61388 7.21392 0.713399 7.37921 0.873976 7.4571L6.58514 10.227L9.35503 15.9381C9.43057 16.0939 9.58832 16.1922 9.76047 16.1922C9.76582 16.1922 9.77119 16.1921 9.77657 16.1919C9.95491 16.1855 10.1128 16.0746 10.179 15.9089L15.9723 1.42577C16.0392 1.25834 16 1.06715 15.8725 0.939654ZM2.18524 7.09117L13.6824 2.49235L6.83057 9.34412L2.18524 7.09117ZM9.72095 14.6269L7.46798 9.98149L14.3198 3.12973L9.72095 14.6269Z"
                          fill="#DD3842" />
                      </g>
                      <defs>
                        <clipPath>
                          <rect width="15.3846" height="15.3846" fill="white"
                            transform="translate(0.619995 0.807617)" />
                        </clipPath>
                      </defs>
                    </svg>
                  </span>
                  <span class="text">Get Started</span>
                </a>
              </div>
            </div>
          </div>
          <div class="col-lg-4 wow fadeInUp animated" data-wow-delay="600ms">
            <div class="pricing-card card-3">
              <div class="topbar mb-32">
                <h4 class="white mb-26">Premium</h4>
                <p class="white">Fundamentals of the subject matter are essential for building a strong foundation.
                  Understanding the basic</p>
              </div>
              <div class="centerbar mb-32">
                <h4 class="color-primary mb-32">$99.00/m</h4>
                <div class="d-flex align-items-center gap-12 mb-16">
                  <svg class="tick-svg" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                    fill="none">
                    <path d="M20 6L9 17L4 12" stroke="#F7B631" stroke-width="2" stroke-linecap="round"
                      stroke-linejoin="round" />
                  </svg>
                  <p>Automated management</p>
                </div>
                <div class="d-flex align-items-center gap-12 mb-16">
                  <svg class="tick-svg" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                    fill="none">
                    <path d="M20 6L9 17L4 12" stroke="#F7B631" stroke-width="2" stroke-linecap="round"
                      stroke-linejoin="round" />
                  </svg>
                  <p>Bug Fixing</p>
                </div>
                <div class="d-flex align-items-center gap-12 mb-16">
                  <svg class="tick-svg" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                    fill="none">
                    <path d="M20 6L9 17L4 12" stroke="#F7B631" stroke-width="2" stroke-linecap="round"
                      stroke-linejoin="round" />
                  </svg>
                  <p>Agile Development</p>
                </div>
                <div class="d-flex align-items-center gap-12 mb-16">
                  <svg class="tick-svg" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                    fill="none">
                    <path d="M20 6L9 17L4 12" stroke="#F7B631" stroke-width="2" stroke-linecap="round"
                      stroke-linejoin="round" />
                  </svg>
                  <p>SOX compliance</p>
                </div>
                <div class="d-flex align-items-center gap-12 mb-16">
                  <svg class="tick-svg" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                    fill="none">
                    <path d="M20 6L9 17L4 12" stroke="#F7B631" stroke-width="2" stroke-linecap="round"
                      stroke-linejoin="round" />
                  </svg>
                  <p>Enterprise ERP integrations</p>
                </div>
                <div class="d-flex align-items-center gap-12 mb-16">
                  <svg class="tick-svg" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                    fill="none">
                    <path d="M20 6L9 17L4 12" stroke="#F7B631" stroke-width="2" stroke-linecap="round"
                      stroke-linejoin="round" />
                  </svg>
                  <p>Limited tools</p>
                </div>
                <div class="d-flex align-items-center gap-12">
                  <svg class="tick-svg" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                    fill="none">
                    <path d="M20 6L9 17L4 12" stroke="#F7B631" stroke-width="2" stroke-linecap="round"
                      stroke-linejoin="round" />
                  </svg>
                  <p>Local video issuance</p>
                </div>
              </div>
              <div class="bottom-bar">
                <a href="" class="cus-btn">
                  <span class="icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17" fill="none">
                      <g clip-path="url(#clip0_13565_592)">
                        <path
                          d="M15.8725 0.939654C15.745 0.81213 15.5538 0.772917 15.3864 0.839864L0.903272 6.63306C0.737558 6.69935 0.62659 6.85716 0.62022 7.03556C0.61388 7.21392 0.713399 7.37921 0.873976 7.4571L6.58514 10.227L9.35503 15.9381C9.43057 16.0939 9.58832 16.1922 9.76047 16.1922C9.76582 16.1922 9.77119 16.1921 9.77657 16.1919C9.95491 16.1855 10.1128 16.0746 10.179 15.9089L15.9723 1.42577C16.0392 1.25834 16 1.06715 15.8725 0.939654ZM2.18524 7.09117L13.6824 2.49235L6.83057 9.34412L2.18524 7.09117ZM9.72095 14.6269L7.46798 9.98149L14.3198 3.12973L9.72095 14.6269Z"
                          fill="#DD3842" />
                      </g>
                      <defs>
                        <clipPath>
                          <rect width="15.3846" height="15.3846" fill="white"
                            transform="translate(0.619995 0.807617)" />
                        </clipPath>
                      </defs>
                    </svg>
                  </span>
                  <span class="text">Get Started</span>
                </a>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- Our Plan Section End -->

    <!-- counter Section Start -->
    <section class="counter-sec mb-120">
      <div class="container-fluid">
        <div class="counter-content">
          <img src="assets/media/hero/vec-2.webp" class="vec-1" alt="">
          <h3>Encouraging a child’s true potential <br class="d-xl-block d-none"> in a loving and safe environment</h3>
          <p>At our daycare, we firmly believe that every child deserves a safe, nurturing, and enjoyable environment
            where they can learn, play, and grow.<br class="d-xl-block d-none"> Our dedicated caregivers are not only
            trained professionals but also passionate individuals who deliver top-notch early childhood education</p>
        </div>
      </div>
    </section>
    <div class="container-fluid mb-120 wow fadeInUp animated" data-wow-delay="400ms">
      <div class="counter-section">
        <div class="counter-count">
          <div class="">
            <span class="count h4 fw-500">7</span>
            <span class="h4 fw-500">K+</span>
          </div>
          <div>
            <h5 class="mb-16">Playing Fun Games</h5>
            <p>At our daycare, we firmly believe.</p>
          </div>
        </div>
        <div class="r-border"></div>
        <div class="counter-count">
          <div class="">
            <span class="count h4 fw-500">88</span>
            <span class="h4 fw-500">+</span>
          </div>
          <div>
            <h5 class="mb-16">Awards Won</h5>
            <p>At our daycare, we firm.</p>
          </div>
        </div>
        <div class="r-border"></div>
        <div class="counter-count">
          <div class="">
            <span class="count h4 fw-500">60</span>
            <span class="h4 fw-500">+</span>
          </div>
          <div>
            <h5 class="mb-16">Total Branchs</h5>
            <p>At our daycare, we firml.</p>
          </div>
        </div>
      </div>
    </div>
    <!-- counter Section End -->

    <!-- Our Work Section Start -->
    <section class="work-sec mb-120">
      <div class="container-fluid">
        <div class="text-center mb-48">
          <h2 class="mb-16">How it <span class="color-primary"> works</span></h2>
          <p>At our daycare, we firmly believe that every child deserves a safe, nurturing, and enjoyable environmen.
          </p>
        </div>
        <div class="row row-gap-4">
          <div class="col-xxl-3 col-lg-4 col-md-6 wow fadeInUp animated" data-wow-delay="400ms">
            <div class="work-card">
              <div class="content">
                <div class="mb-24">
                  <svg xmlns="http://www.w3.org/2000/svg" width="57" height="57" viewBox="0 0 57 57" fill="none">
                    <path
                      d="M47.75 52.5625H16.25C15.4381 52.5615 14.6597 52.2385 14.0856 51.6644C13.5115 51.0903 13.1885 50.3119 13.1875 49.5V23.0748C13.1875 22.7267 13.3258 22.3929 13.5719 22.1467C13.8181 21.9006 14.1519 21.7623 14.5 21.7623C14.8481 21.7623 15.1819 21.9006 15.4281 22.1467C15.6742 22.3929 15.8125 22.7267 15.8125 23.0748V49.5C15.8139 49.6156 15.8604 49.7261 15.9421 49.8078C16.0239 49.8896 16.1344 49.9361 16.25 49.9375H47.75C47.8656 49.9361 47.9761 49.8896 48.0578 49.8078C48.1396 49.7261 48.1861 49.6156 48.1875 49.5V13.4678C48.1841 13.357 48.1404 13.2512 48.0645 13.1704L42.0796 7.18554C41.9988 7.10962 41.893 7.06585 41.7822 7.0625H16.25C15.9019 7.0625 15.5681 6.92422 15.3219 6.67808C15.0758 6.43194 14.9375 6.0981 14.9375 5.75C14.9375 5.4019 15.0758 5.06806 15.3219 4.82192C15.5681 4.57578 15.9019 4.4375 16.25 4.4375H41.7822C42.5895 4.43957 43.3633 4.76016 43.9355 5.3296L49.9204 11.3145C50.4898 11.8867 50.8104 12.6605 50.8125 13.4678V49.5C50.8115 50.3119 50.4885 51.0903 49.9144 51.6644C49.3403 52.2385 48.5619 52.5615 47.75 52.5625Z"
                      fill="#F7B631" />
                    <path
                      d="M49.3248 14.0616H44.25C43.4381 14.0607 42.6597 13.7377 42.0856 13.1636C41.5115 12.5895 41.1885 11.8111 41.1875 10.9991V5.92432C41.1875 5.57622 41.3258 5.24238 41.5719 4.99624C41.8181 4.7501 42.1519 4.61182 42.5 4.61182C42.8481 4.61182 43.1819 4.7501 43.4281 4.99624C43.6742 5.24238 43.8125 5.57622 43.8125 5.92432V10.9991C43.8139 11.1148 43.8604 11.2252 43.9421 11.307C44.0239 11.3887 44.1344 11.4353 44.25 11.4366H49.3248C49.6729 11.4366 50.0068 11.5749 50.2529 11.8211C50.499 12.0672 50.6373 12.401 50.6373 12.7491C50.6373 13.0972 50.499 13.4311 50.2529 13.6772C50.0068 13.9234 49.6729 14.0616 49.3248 14.0616Z"
                      fill="#F7B631" />
                    <path
                      d="M14.9374 18.4374C14.765 18.4376 14.5943 18.4037 14.435 18.3377C14.2758 18.2718 14.1311 18.1749 14.0094 18.0529L11.3844 15.4279C11.1398 15.1814 11.0028 14.8481 11.0034 14.5009C11.0041 14.1537 11.1423 13.8208 11.3878 13.5753C11.6333 13.3298 11.9662 13.1916 12.3134 13.1909C12.6606 13.1903 12.9939 13.3273 13.2404 13.5719L14.9374 15.2689L19.2594 10.9469C19.5058 10.7023 19.8392 10.5653 20.1864 10.5659C20.5336 10.5666 20.8665 10.7048 21.112 10.9503C21.3575 11.1958 21.4957 11.5287 21.4964 11.8759C21.497 12.2231 21.36 12.5564 21.1154 12.8029L15.8654 18.0529C15.7437 18.1749 15.599 18.2718 15.4398 18.3377C15.2805 18.4037 15.1098 18.4376 14.9374 18.4374Z"
                      fill="#F7B631" />
                    <path
                      d="M16.25 24.5625C14.2598 24.5625 12.3143 23.9724 10.6596 22.8667C9.00481 21.761 7.71507 20.1894 6.95347 18.3508C6.19186 16.5121 5.99259 14.4888 6.38085 12.5369C6.76912 10.585 7.72748 8.79201 9.13474 7.38474C10.542 5.97748 12.335 5.01912 14.2869 4.63085C16.2388 4.24259 18.2621 4.44186 20.1008 5.20347C21.9394 5.96507 23.511 7.25481 24.6167 8.90958C25.7224 10.5643 26.3125 12.5098 26.3125 14.5C26.3094 17.1678 25.2482 19.7254 23.3618 21.6118C21.4754 23.4982 18.9178 24.5594 16.25 24.5625ZM16.25 7.0625C14.779 7.0625 13.341 7.49871 12.118 8.31595C10.8949 9.13319 9.94158 10.2948 9.37865 11.6538C8.81572 13.0128 8.66844 14.5083 8.95541 15.951C9.24239 17.3937 9.95075 18.719 10.9909 19.7591C12.0311 20.7993 13.3563 21.5076 14.799 21.7946C16.2418 22.0816 17.7372 21.9343 19.0962 21.3714C20.4552 20.8084 21.6168 19.8552 22.4341 18.6321C23.2513 17.409 23.6875 15.971 23.6875 14.5C23.6852 12.5282 22.9008 10.6378 21.5065 9.24349C20.1122 7.8492 18.2218 7.06485 16.25 7.0625Z"
                      fill="#F7B631" />
                    <path
                      d="M31.1265 47.7218C30.8015 47.723 30.4826 47.6331 30.2061 47.4622C29.9296 47.2914 29.7064 47.0466 29.562 46.7554L28.2768 44.1859L26.9267 45.9872C26.7174 46.2646 26.4066 46.4477 26.0624 46.4964C25.7183 46.545 25.3689 46.4552 25.0909 46.2466C24.8129 46.038 24.629 45.7277 24.5794 45.3837C24.5298 45.0398 24.6186 44.6901 24.8264 44.4115L27.0266 41.478C27.2037 41.2374 27.4404 41.0471 27.7134 40.9257C27.9864 40.8043 28.2863 40.7561 28.5835 40.7859C28.8808 40.8116 29.1666 40.9134 29.4132 41.0814C29.6598 41.2495 29.859 41.4782 29.9917 41.7455L31.1265 44.015L32.2612 41.7455C32.3948 41.4789 32.5942 41.2508 32.8407 41.0829C33.0871 40.9149 33.3723 40.8127 33.6693 40.7859C33.9663 40.7591 34.2652 40.8087 34.5377 40.9298C34.8102 41.0509 35.0472 41.2396 35.2263 41.4781L37.0319 43.8869H44.2515C44.5996 43.8869 44.9334 44.0252 45.1796 44.2713C45.4257 44.5174 45.564 44.8513 45.564 45.1994C45.564 45.5475 45.4257 45.8813 45.1796 46.1274C44.9334 46.3736 44.5996 46.5119 44.2515 46.5119H36.5952C36.3239 46.5114 36.0563 46.4481 35.8135 46.327C35.5707 46.2058 35.3592 46.0302 35.1956 45.8137L33.9754 44.1868L32.6919 46.7545C32.5474 47.0459 32.3241 47.2909 32.0474 47.4619C31.7707 47.6329 31.4517 47.7229 31.1265 47.7218Z"
                      fill="#F7B631" />
                    <path
                      d="M42.5 29.8125H23.25C22.9019 29.8125 22.5681 29.6742 22.3219 29.4281C22.0758 29.1819 21.9375 28.8481 21.9375 28.5C21.9375 28.1519 22.0758 27.8181 22.3219 27.5719C22.5681 27.3258 22.9019 27.1875 23.25 27.1875H42.5C42.8481 27.1875 43.1819 27.3258 43.4281 27.5719C43.6742 27.8181 43.8125 28.1519 43.8125 28.5C43.8125 28.8481 43.6742 29.1819 43.4281 29.4281C43.1819 29.6742 42.8481 29.8125 42.5 29.8125Z"
                      fill="#F7B631" />
                    <path
                      d="M42.5 23.6875H26.75C26.4019 23.6875 26.0681 23.5492 25.8219 23.3031C25.5758 23.0569 25.4375 22.7231 25.4375 22.375C25.4375 22.0269 25.5758 21.6931 25.8219 21.4469C26.0681 21.2008 26.4019 21.0625 26.75 21.0625H42.5C42.8481 21.0625 43.1819 21.2008 43.4281 21.4469C43.6742 21.6931 43.8125 22.0269 43.8125 22.375C43.8125 22.7231 43.6742 23.0569 43.4281 23.3031C43.1819 23.5492 42.8481 23.6875 42.5 23.6875Z"
                      fill="#F7B631" />
                    <path
                      d="M42.5 17.5625H28.5C28.1519 17.5625 27.8181 17.4242 27.5719 17.1781C27.3258 16.9319 27.1875 16.5981 27.1875 16.25C27.1875 15.9019 27.3258 15.5681 27.5719 15.3219C27.8181 15.0758 28.1519 14.9375 28.5 14.9375H42.5C42.8481 14.9375 43.1819 15.0758 43.4281 15.3219C43.6742 15.5681 43.8125 15.9019 43.8125 16.25C43.8125 16.5981 43.6742 16.9319 43.4281 17.1781C43.1819 17.4242 42.8481 17.5625 42.5 17.5625Z"
                      fill="#F7B631" />
                    <path
                      d="M42.5 35.9375H21.5C21.1519 35.9375 20.8181 35.7992 20.5719 35.5531C20.3258 35.3069 20.1875 34.9731 20.1875 34.625C20.1875 34.2769 20.3258 33.9431 20.5719 33.6969C20.8181 33.4508 21.1519 33.3125 21.5 33.3125H42.5C42.8481 33.3125 43.1819 33.4508 43.4281 33.6969C43.6742 33.9431 43.8125 34.2769 43.8125 34.625C43.8125 34.9731 43.6742 35.3069 43.4281 35.5531C43.1819 35.7992 42.8481 35.9375 42.5 35.9375Z"
                      fill="#F7B631" />
                  </svg>
                </div>
                <h5 class="mb-24">Fill Admission Form</h5>
                <p class="pb-22">At our daycare, we firmly believe that every child deserves a safe, nurturing,
                  and
                  enjoyable environmen.</p>
              </div>
              <div class="num-icon">
                <h5 class="color-primary">01</h5>
              </div>
            </div>
          </div>
          <div class="col-xxl-3 col-lg-4 col-md-6 wow fadeInUp animated" data-wow-delay="550ms">
            <div class="work-card">
              <div class="content">
                <div class="mb-24">
                  <svg xmlns="http://www.w3.org/2000/svg" width="57" height="57" viewBox="0 0 57 57" fill="none">
                    <path fill-rule="evenodd" clip-rule="evenodd"
                      d="M36.7338 53.5491C36.711 53.5491 36.6996 53.5491 36.6768 53.5491C36.3806 53.515 36.1527 53.2529 36.1869 52.9567L37.1212 43.4088C34.8994 42.953 33.236 41.1186 32.9967 38.8627H24.0071C23.7792 41.1186 22.1043 42.953 19.8825 43.4088L20.8168 52.9567C20.851 53.2529 20.6231 53.5264 20.3269 53.5491C20.0307 53.5833 19.7572 53.3554 19.723 53.0592L18.7432 42.9986C18.7318 42.8505 18.7774 42.7137 18.8685 42.5998C18.9597 42.4859 19.0964 42.4175 19.2331 42.4061C21.3409 42.201 22.9361 40.4464 22.9361 38.3272C22.9361 38.0195 23.1753 37.7803 23.483 37.7803H33.5094C33.817 37.7803 34.0563 38.0195 34.0563 38.3272C34.0563 40.4464 35.6514 42.201 37.7592 42.4061C37.9074 42.4175 38.0327 42.4859 38.1238 42.5998C38.215 42.7137 38.2606 42.8505 38.2492 42.9986L37.2693 53.0592C37.2465 53.3441 37.0073 53.5491 36.7338 53.5491Z"
                      fill="#21AC94" />
                    <path fill-rule="evenodd" clip-rule="evenodd"
                      d="M38.3519 27.0813C38.0898 27.0813 37.8506 26.8876 37.8164 26.6255L36.9163 21.1338C36.7226 19.926 35.9364 18.5132 34.3755 18.5132H22.64C21.0791 18.5132 20.2929 19.926 20.0992 21.1338L19.1991 26.6255C19.1535 26.9218 18.8687 27.1269 18.5724 27.0813C18.2762 27.0357 18.0711 26.7509 18.1167 26.4546L19.0168 20.9629C19.3586 18.8436 20.817 17.4194 22.64 17.4194H34.3869C36.2099 17.4194 37.6569 18.8436 38.0101 20.9629L38.9102 26.4546C38.9558 26.7509 38.7621 27.0357 38.4544 27.0813C38.4089 27.0699 38.3747 27.0813 38.3519 27.0813Z"
                      fill="#21AC94" />
                    <path fill-rule="evenodd" clip-rule="evenodd"
                      d="M28.5066 4.54448C26.4785 4.54448 24.3023 5.9573 24.3023 9.05638C24.3023 12.0757 26.5582 14.4228 28.5066 14.4228C30.4435 14.4228 32.6994 12.0757 32.6994 9.05638C32.6994 5.9573 30.5232 4.54448 28.5066 4.54448ZM28.5066 15.5166C25.7379 15.5166 23.2085 12.4403 23.2085 9.05638C23.2085 5.37622 25.8746 3.45068 28.5066 3.45068C31.1385 3.45068 33.7932 5.37622 33.7932 9.05638C33.7932 12.4403 31.2752 15.5166 28.5066 15.5166Z"
                      fill="#21AC94" />
                    <path fill-rule="evenodd" clip-rule="evenodd"
                      d="M14.0138 27.0696C13.7062 27.0696 13.4669 26.8303 13.4669 26.5227V15.391C13.4669 14.1036 14.5151 13.0439 15.8026 13.0439H17.0218C17.3294 13.0439 17.5686 13.2832 17.5686 13.5908C17.5686 13.8871 17.318 14.1377 17.0218 14.1377H15.8026C15.119 14.1377 14.5493 14.696 14.5493 15.391V26.5227C14.5607 26.8303 14.3101 27.0696 14.0138 27.0696Z"
                      fill="#21AC94" />
                    <path fill-rule="evenodd" clip-rule="evenodd"
                      d="M18.9246 12.6114C18.184 12.6114 17.5687 13.0671 17.5687 13.6026C17.5687 14.1381 18.184 14.5939 18.9246 14.5939C19.6538 14.5939 20.2804 14.1381 20.2804 13.6026C20.2804 13.0557 19.6538 12.6114 18.9246 12.6114ZM18.9246 15.6877C17.5687 15.6877 16.4749 14.7534 16.4749 13.6026C16.4749 12.4519 17.5687 11.5176 18.9246 11.5176C20.2804 11.5176 21.3742 12.4519 21.3742 13.6026C21.3742 14.7534 20.2804 15.6877 18.9246 15.6877Z"
                      fill="#21AC94" />
                    <path fill-rule="evenodd" clip-rule="evenodd"
                      d="M42.988 27.0696C42.6804 27.0696 42.4411 26.8303 42.4411 26.5227V15.391C42.4411 14.7074 41.8829 14.1377 41.1878 14.1377H39.9687C39.6611 14.1377 39.4218 13.8985 39.4218 13.5908C39.4218 13.2832 39.6611 13.0439 39.9687 13.0439H41.1878C42.4753 13.0439 43.5235 14.0922 43.5235 15.391V26.5227C43.5349 26.8303 43.2957 27.0696 42.988 27.0696Z"
                      fill="#21AC94" />
                    <path fill-rule="evenodd" clip-rule="evenodd"
                      d="M38.0773 12.6114C37.3481 12.6114 36.7214 13.0671 36.7214 13.6026C36.7214 14.1381 37.3367 14.5939 38.0773 14.5939C38.8065 14.5939 39.4331 14.1381 39.4331 13.6026C39.4331 13.0557 38.8065 12.6114 38.0773 12.6114ZM38.0773 15.6877C36.7214 15.6877 35.6276 14.7534 35.6276 13.6026C35.6276 12.4519 36.7214 11.5176 38.0773 11.5176C39.4331 11.5176 40.5269 12.4519 40.5269 13.6026C40.5269 14.7534 39.4331 15.6877 38.0773 15.6877Z"
                      fill="#21AC94" />
                    <path fill-rule="evenodd" clip-rule="evenodd"
                      d="M10.6651 33.3937H46.3387V27.0816H10.6651V33.3937ZM46.8856 34.4875H10.1182C9.81056 34.4875 9.57129 34.2482 9.57129 33.9406V26.5347C9.57129 26.2271 9.81056 25.9878 10.1182 25.9878H46.8856C47.1933 25.9878 47.4325 26.2271 47.4325 26.5347V33.9406C47.4325 34.2368 47.1933 34.4875 46.8856 34.4875Z"
                      fill="#21AC94" />
                    <path fill-rule="evenodd" clip-rule="evenodd"
                      d="M41.1204 53.5488H15.8833C15.5985 53.5488 15.3706 53.3323 15.3364 53.0589L13.4679 33.9972C13.4337 33.701 13.6616 33.4276 13.9578 33.4048C14.254 33.3706 14.5275 33.5985 14.5503 33.8947L16.3733 52.4664H40.619L42.4306 33.8947C42.4648 33.5985 42.7269 33.3706 43.0231 33.4048C43.3194 33.4389 43.5472 33.701 43.513 33.9972L41.6445 53.0589C41.6445 53.3323 41.4052 53.5488 41.1204 53.5488Z"
                      fill="#21AC94" />
                  </svg>
                </div>
                <h5 class="mb-24">Brief with Us</h5>
                <p class="pb-22">At our daycare, we firmly believe that every child deserves a safe, nurturing,
                  and
                  enjoyable environmen.</p>
              </div>
              <div class="num-icon">
                <h5 class="color-primary">02</h5>
              </div>
            </div>
          </div>
          <div class="col-xxl-3 col-lg-4 col-md-6 wow fadeInUp animated" data-wow-delay="750ms">
            <div class="work-card">
              <div class="content">
                <div class="mb-24">
                  <svg xmlns="http://www.w3.org/2000/svg" width="57" height="57" viewBox="0 0 57 57" fill="none">
                    <path
                      d="M48.3333 16.8333H6.33329C6.18007 16.8334 6.02835 16.8032 5.88678 16.7446C5.74522 16.686 5.61659 16.6001 5.50825 16.4917C5.3999 16.3834 5.31397 16.2547 5.25535 16.1132C5.19674 15.9716 5.16659 15.8199 5.16663 15.6667V8.66667C5.16659 8.51345 5.19674 8.36172 5.25535 8.22016C5.31397 8.07859 5.3999 7.94996 5.50825 7.84162C5.61659 7.73328 5.74522 7.64734 5.88678 7.58873C6.02835 7.53011 6.18007 7.49996 6.33329 7.5H48.3333C48.4865 7.49991 48.6383 7.53003 48.7799 7.58863C48.9214 7.64723 49.0501 7.73316 49.1584 7.84151C49.2668 7.94987 49.3527 8.07851 49.4113 8.2201C49.4699 8.36169 49.5 8.51343 49.5 8.66667V15.6667C49.5 15.8199 49.4699 15.9716 49.4113 16.1132C49.3527 16.2548 49.2668 16.3835 49.1584 16.4918C49.0501 16.6002 48.9214 16.6861 48.7799 16.7447C48.6383 16.8033 48.4865 16.8334 48.3333 16.8333ZM7.49996 14.5H47.1666V9.83333H7.49996V14.5Z"
                      fill="#21AC94" />
                    <path
                      d="M14.5 13.3333C13.7267 13.3325 12.9853 13.025 12.4385 12.4782C11.8917 11.9314 11.5842 11.19 11.5834 10.4167V6.91667C11.5834 6.14312 11.8907 5.40125 12.4376 4.85427C12.9846 4.30729 13.7265 4 14.5 4C15.2736 4 16.0155 4.30729 16.5624 4.85427C17.1094 5.40125 17.4167 6.14312 17.4167 6.91667V8.66667C17.4167 8.97609 17.2938 9.27283 17.075 9.49162C16.8562 9.71042 16.5595 9.83333 16.25 9.83333C15.9406 9.83333 15.6439 9.71042 15.4251 9.49162C15.2063 9.27283 15.0834 8.97609 15.0834 8.66667V6.91667C15.0834 6.76196 15.0219 6.61358 14.9125 6.50419C14.8031 6.39479 14.6548 6.33333 14.5 6.33333C14.3453 6.33333 14.197 6.39479 14.0876 6.50419C13.9782 6.61358 13.9167 6.76196 13.9167 6.91667V10.4167C13.9169 10.5713 13.9784 10.7196 14.0878 10.8289C14.1971 10.9383 14.3454 10.9998 14.5 11C14.8095 11 15.1062 11.1229 15.325 11.3417C15.5438 11.5605 15.6667 11.8572 15.6667 12.1667C15.6667 12.4761 15.5438 12.7728 15.325 12.9916C15.1062 13.2104 14.8095 13.3333 14.5 13.3333Z"
                      fill="#21AC94" />
                    <path
                      d="M22.6667 13.3333C21.8934 13.3325 21.152 13.025 20.6052 12.4782C20.0584 11.9314 19.7508 11.19 19.75 10.4167V6.91667C19.75 6.14312 20.0573 5.40125 20.6043 4.85427C21.1513 4.30729 21.8931 4 22.6667 4C23.4402 4 24.1821 4.30729 24.7291 4.85427C25.276 5.40125 25.5833 6.14312 25.5833 6.91667V8.66667C25.5833 8.97609 25.4604 9.27283 25.2416 9.49162C25.0228 9.71042 24.7261 9.83333 24.4167 9.83333C24.1072 9.83333 23.8105 9.71042 23.5917 9.49162C23.3729 9.27283 23.25 8.97609 23.25 8.66667V6.91667C23.25 6.76196 23.1885 6.61358 23.0791 6.50419C22.9698 6.39479 22.8214 6.33333 22.6667 6.33333C22.512 6.33333 22.3636 6.39479 22.2542 6.50419C22.1448 6.61358 22.0833 6.76196 22.0833 6.91667V10.4167C22.0835 10.5713 22.1451 10.7196 22.2544 10.8289C22.3638 10.9383 22.512 10.9998 22.6667 11C22.9761 11 23.2728 11.1229 23.4916 11.3417C23.7104 11.5605 23.8333 11.8572 23.8333 12.1667C23.8333 12.4761 23.7104 12.7728 23.4916 12.9916C23.2728 13.2104 22.9761 13.3333 22.6667 13.3333Z"
                      fill="#21AC94" />
                    <path
                      d="M30.8333 13.3333C30.06 13.3325 29.3186 13.025 28.7718 12.4782C28.225 11.9314 27.9174 11.19 27.9166 10.4167V6.91667C27.9166 6.14312 28.2239 5.40125 28.7709 4.85427C29.3179 4.30729 30.0597 4 30.8333 4C31.6068 4 32.3487 4.30729 32.8957 4.85427C33.4427 5.40125 33.75 6.14312 33.75 6.91667V8.66667C33.75 8.97609 33.627 9.27283 33.4083 9.49162C33.1895 9.71042 32.8927 9.83333 32.5833 9.83333C32.2739 9.83333 31.9771 9.71042 31.7583 9.49162C31.5395 9.27283 31.4166 8.97609 31.4166 8.66667V6.91667C31.4166 6.76196 31.3552 6.61358 31.2458 6.50419C31.1364 6.39479 30.988 6.33333 30.8333 6.33333C30.6786 6.33333 30.5302 6.39479 30.4208 6.50419C30.3114 6.61358 30.25 6.76196 30.25 6.91667V10.4167C30.2503 10.5713 30.3118 10.7195 30.4212 10.8288C30.5305 10.9381 30.6787 10.9997 30.8333 11C31.1427 11 31.4395 11.1229 31.6583 11.3417C31.877 11.5605 32 11.8572 32 12.1667C32 12.4761 31.877 12.7728 31.6583 12.9916C31.4395 13.2104 31.1427 13.3333 30.8333 13.3333Z"
                      fill="#21AC94" />
                    <path
                      d="M39 13.3333C38.2267 13.3326 37.4853 13.0251 36.9384 12.4783C36.3916 11.9314 36.0841 11.19 36.0834 10.4167V6.91667C36.0834 6.14312 36.3907 5.40125 36.9376 4.85427C37.4846 4.30729 38.2265 4 39 4C39.7736 4 40.5155 4.30729 41.0624 4.85427C41.6094 5.40125 41.9167 6.14312 41.9167 6.91667V8.66667C41.9167 8.97609 41.7938 9.27283 41.575 9.49162C41.3562 9.71042 41.0595 9.83333 40.75 9.83333C40.4406 9.83333 40.1439 9.71042 39.9251 9.49162C39.7063 9.27283 39.5834 8.97609 39.5834 8.66667V6.91667C39.5834 6.76196 39.5219 6.61358 39.4125 6.50419C39.3031 6.39479 39.1548 6.33333 39 6.33333C38.8453 6.33333 38.697 6.39479 38.5876 6.50419C38.4782 6.61358 38.4167 6.76196 38.4167 6.91667V10.4167C38.417 10.5713 38.4786 10.7195 38.5879 10.8288C38.6972 10.9381 38.8454 10.9997 39 11C39.3095 11 39.6062 11.1229 39.825 11.3417C40.0438 11.5605 40.1667 11.8572 40.1667 12.1667C40.1667 12.4761 40.0438 12.7728 39.825 12.9916C39.6062 13.2104 39.3095 13.3333 39 13.3333Z"
                      fill="#21AC94" />
                    <path
                      d="M31.4166 51.8333H6.33329C6.18007 51.8334 6.02835 51.8032 5.88678 51.7446C5.74522 51.686 5.61659 51.6001 5.50825 51.4917C5.3999 51.3834 5.31397 51.2547 5.25535 51.1132C5.19674 50.9716 5.16659 50.8199 5.16663 50.6667V15.6667C5.16659 15.5134 5.19674 15.3617 5.25535 15.2202C5.31397 15.0786 5.3999 14.95 5.50825 14.8416C5.61659 14.7333 5.74522 14.6473 5.88678 14.5887C6.02835 14.5301 6.18007 14.5 6.33329 14.5H48.3333C48.4865 14.4999 48.6383 14.53 48.7799 14.5886C48.9214 14.6472 49.0501 14.7332 49.1584 14.8415C49.2668 14.9499 49.3527 15.0785 49.4113 15.2201C49.4699 15.3617 49.5 15.5134 49.5 15.6667V36.3283C49.5 36.6378 49.377 36.9345 49.1582 37.1533C48.9395 37.3721 48.6427 37.495 48.3333 37.495C48.0239 37.495 47.7271 37.3721 47.5083 37.1533C47.2895 36.9345 47.1666 36.6378 47.1666 36.3283V16.8333H7.49996V49.5H31.4166C31.726 49.5 32.0228 49.6229 32.2416 49.8417C32.4604 50.0605 32.5833 50.3572 32.5833 50.6667C32.5833 50.9761 32.4604 51.2728 32.2416 51.4916C32.0228 51.7104 31.726 51.8333 31.4166 51.8333Z"
                      fill="#21AC94" />
                    <path d="M11.5826 21.5H16.2493V26.1667H11.5826V21.5Z" fill="#21AC94" />
                    <path d="M20.3326 21.5H24.9993V26.1667H20.3326V21.5Z" fill="#21AC94" />
                    <path d="M11.5826 30.8335H16.2493V35.5002H11.5826V30.8335Z" fill="#21AC94" />
                    <path d="M20.3326 30.8335H24.9993V35.5002H20.3326V30.8335Z" fill="#21AC94" />
                    <path d="M29.0826 30.8335H33.7493V35.5002H29.0826V30.8335Z" fill="#21AC94" />
                    <path d="M11.5826 40.1665H16.2493V44.8332H11.5826V40.1665Z" fill="#21AC94" />
                    <path d="M20.3326 40.1665H24.9993V44.8332H20.3326V40.1665Z" fill="#21AC94" />
                    <path d="M29.0826 21.5H33.7493V26.1667H29.0826V21.5Z" fill="#21AC94" />
                    <path d="M37.8326 21.5H42.4993V26.1667H37.8326V21.5Z" fill="#21AC94" />
                    <path
                      d="M41.333 53C39.8433 52.9987 38.371 52.6804 37.0138 52.0662C35.6566 51.4521 34.4456 50.5562 33.4612 49.4381C32.4769 48.32 31.7417 47.0052 31.3046 45.5811C30.8675 44.157 30.7384 42.6561 30.9259 41.1783C31.1134 39.7005 31.6133 38.2795 32.3922 37.0096C33.1712 35.7398 34.2114 34.6503 35.4438 33.8135C36.6762 32.9766 38.0725 32.4115 39.5401 32.1558C41.0077 31.9001 42.5129 31.9596 43.9557 32.3304C44.2554 32.4071 44.5124 32.5998 44.6701 32.8661C44.8278 33.1323 44.8732 33.4502 44.7965 33.75C44.7197 34.0497 44.5271 34.3067 44.2608 34.4644C43.9946 34.6221 43.6766 34.6676 43.3769 34.5908C41.7276 34.1642 39.9862 34.264 38.3964 34.8762C36.8067 35.4884 35.4481 36.5823 34.5109 38.0049C33.5736 39.4275 33.1046 41.1075 33.1695 42.8098C33.2344 44.5121 33.83 46.1516 34.8728 47.4987C35.9156 48.8457 37.3536 49.8331 38.9853 50.3224C40.6171 50.8118 42.361 50.7787 43.973 50.2278C45.5851 49.6769 46.9845 48.6357 47.9755 47.2501C48.9665 45.8644 49.4994 44.2036 49.4997 42.5C49.501 40.511 48.7748 38.5902 47.458 37.0996C47.3566 36.9847 47.2788 36.8509 47.229 36.706C47.1793 36.561 47.1586 36.4076 47.1681 36.2546C47.1776 36.1017 47.2172 35.952 47.2845 35.8144C47.3518 35.6767 47.4456 35.5536 47.5605 35.4521C47.6755 35.3507 47.8092 35.2729 47.9542 35.2231C48.0992 35.1734 48.2525 35.1527 48.4055 35.1622C48.5585 35.1717 48.7081 35.2113 48.8458 35.2786C48.9835 35.346 49.1066 35.4398 49.208 35.5547C50.5446 37.0702 51.4154 38.9392 51.7161 40.9375C52.0168 42.9357 51.7345 44.9782 50.9031 46.82C50.0717 48.6617 48.7266 50.2245 47.029 51.3207C45.3315 52.4169 43.3537 53 41.333 53Z"
                      fill="#21AC94" />
                    <path
                      d="M44.8321 46.0002C44.6022 46 44.3774 45.9318 44.1861 45.8042L40.6861 43.4708C40.5264 43.3643 40.3953 43.2199 40.3047 43.0506C40.2141 42.8813 40.1667 42.6922 40.1666 42.5002V39.0002C40.1666 38.6907 40.2895 38.394 40.5083 38.1752C40.7271 37.9564 41.0239 37.8335 41.3333 37.8335C41.6427 37.8335 41.9395 37.9564 42.1583 38.1752C42.377 38.394 42.5 38.6907 42.5 39.0002V41.8758L45.4804 43.8628C45.6888 44.0018 45.847 44.2041 45.9315 44.4399C46.016 44.6757 46.0223 44.9324 45.9496 45.1721C45.8769 45.4118 45.729 45.6218 45.5278 45.7709C45.3265 45.92 45.0826 46.0004 44.8321 46.0002Z"
                      fill="#21AC94" />
                  </svg>
                </div>
                <h5 class="mb-24">Work Schedule</h5>
                <p class="pb-22">At our daycare, we firmly believe that every child deserves a safe, nurturing, and
                  enjoyable environmen.</p>
              </div>
              <div class="num-icon">
                <h5 class="color-primary">03</h5>
              </div>
            </div>
          </div>
          <div class="col-xxl-3 col-lg-4 col-md-6 d-xxl-block d-lg-none wow fadeInUp animated" data-wow-delay="900ms">
            <div class="work-card">
              <div class="content">
                <div class="mb-24">
                  <svg xmlns="http://www.w3.org/2000/svg" width="57" height="57" viewBox="0 0 57 57" fill="none">
                    <path
                      d="M28.3284 14.2015C20.4225 14.2015 13.9892 20.6317 13.9892 28.5346C13.9892 36.4375 20.4225 42.8771 28.3284 42.8771C36.2344 42.8771 42.6677 36.4437 42.6677 28.5346C42.6677 20.6255 36.2344 14.2015 28.3284 14.2015ZM28.3284 44.6225C19.4582 44.6225 12.2405 37.4079 12.2405 28.5345C12.2405 19.6611 19.4582 12.4497 28.3284 12.4497C37.1987 12.4497 44.4164 19.6675 44.4164 28.5346C44.4164 37.4018 37.1987 44.6225 28.3284 44.6225Z"
                      fill="#21AC94" />
                    <path
                      d="M25.0699 32.379C24.8343 32.379 24.5956 32.286 24.4251 32.0937C24.0996 31.7372 24.1243 31.1854 24.4808 30.8597L27.4541 28.15V24.5101C27.4541 24.0264 27.8448 23.6357 28.3284 23.6357C28.8121 23.6357 29.2028 24.0264 29.2028 24.5101V28.5344C29.2028 28.7825 29.1005 29.0181 28.9175 29.1824L25.659 32.1526C25.4916 32.3045 25.2808 32.3789 25.0699 32.3789V32.379Z"
                      fill="#21AC94" />
                    <path
                      d="M38.5503 29.4117H37.0808C36.5971 29.4117 36.2064 29.0179 36.2064 28.5343C36.2064 28.0537 36.5971 27.6631 37.0808 27.6631H38.5503C39.034 27.6631 39.4247 28.0538 39.4247 28.5343C39.4247 29.0179 39.034 29.4117 38.5503 29.4117Z"
                      fill="#21AC94" />
                    <path
                      d="M28.3284 39.6339C27.8448 39.6339 27.4541 39.2432 27.4541 38.7565V37.29C27.4541 36.8063 27.8448 36.4126 28.3284 36.4126C28.8121 36.4126 29.2028 36.8063 29.2028 37.29V38.7565C29.2028 39.2432 28.8121 39.6339 28.3284 39.6339Z"
                      fill="#21AC94" />
                    <path
                      d="M19.5761 29.4117H18.1065C17.6229 29.4117 17.2322 29.0179 17.2322 28.5343C17.2322 28.0537 17.6229 27.6631 18.1065 27.6631H19.5761C20.0597 27.6631 20.4504 28.0538 20.4504 28.5343C20.4504 29.0179 20.0597 29.4117 19.5761 29.4117Z"
                      fill="#21AC94" />
                    <path
                      d="M28.3284 20.6597C27.8448 20.6597 27.4541 20.269 27.4541 19.7885V18.3157C27.4541 17.8321 27.8448 17.4414 28.3284 17.4414C28.8121 17.4414 29.2028 17.8321 29.2028 18.3157V19.7885C29.2028 20.2691 28.8121 20.6597 28.3284 20.6597Z"
                      fill="#21AC94" />
                    <path
                      d="M14.1543 10.0464C13.8877 10.0464 13.621 9.92552 13.4505 9.68982C13.1652 9.30231 13.2489 8.75346 13.6365 8.46832C17.9213 5.32762 23.0029 3.66895 28.3293 3.66895C32.0901 3.66895 35.7021 4.48434 39.0628 6.09652C39.5 6.30729 39.6829 6.82824 39.4721 7.26541C39.2644 7.69952 38.7436 7.8824 38.3064 7.6747C35.1843 6.17724 31.8266 5.41446 28.3293 5.41446C23.378 5.41446 18.6561 6.95851 14.6721 9.87904C14.5171 9.99377 14.3341 10.0464 14.1543 10.0464ZM6.67931 39.7667C6.35381 39.7667 6.04067 39.5869 5.89181 39.2707C4.27962 35.9099 3.46106 32.2948 3.46106 28.534C3.46106 23.2076 5.1229 18.126 8.26361 13.8475C8.54886 13.4568 9.09453 13.3731 9.48522 13.6584C9.8759 13.9436 9.95958 14.4924 9.67126 14.8799C6.75379 18.8608 5.20975 23.5827 5.20975 28.534C5.20975 32.0313 5.96936 35.389 7.46681 38.5173C7.67768 38.9515 7.49164 39.4754 7.05753 39.6831C6.93656 39.742 6.8064 39.7667 6.67931 39.7667ZM47.6913 43.5864C47.5115 43.5864 47.3317 43.5307 47.1735 43.4159C46.786 43.1307 46.7022 42.5819 46.9875 42.1944C49.905 38.2166 51.449 33.4916 51.449 28.534C51.449 25.0398 50.6894 21.6821 49.1919 18.557C48.9811 18.1229 49.1671 17.602 49.6012 17.3912C50.0384 17.1835 50.5592 17.3664 50.767 17.8036C52.3791 21.1645 53.1977 24.7764 53.1977 28.534C53.1977 33.8667 51.539 38.9483 48.3952 43.2268C48.2246 43.4625 47.961 43.5864 47.6913 43.5864ZM28.3293 53.4054C24.5747 53.4054 20.9659 52.59 17.5958 50.9778C17.1617 50.7701 16.9788 50.2461 17.1865 49.8121C17.3942 49.3749 17.9151 49.192 18.3522 49.3997C21.4806 50.8972 24.8383 51.6568 28.3293 51.6568C33.2806 51.6568 38.0056 50.1159 41.9865 47.1953C42.3772 46.91 42.926 46.9937 43.2112 47.3844C43.4965 47.7719 43.4096 48.3207 43.0221 48.6059C38.7373 51.7466 33.6558 53.4053 28.3293 53.4053V53.4054Z"
                      fill="#21AC94" />
                    <path
                      d="M34.2946 9.93474C33.9721 9.93474 33.6652 9.75492 33.5101 9.44802C33.2962 9.01391 33.4729 8.49 33.9069 8.27606L37.5127 6.4903L35.6246 2.67683C35.4106 2.24272 35.5874 1.71881 36.0214 1.50488C36.4555 1.29094 36.9794 1.46769 37.1933 1.90169L39.469 6.49653C39.6829 6.93064 39.5062 7.45455 39.0722 7.66849L34.682 9.84188C34.5579 9.90389 34.4246 9.93495 34.2945 9.93495L34.2946 9.93474Z"
                      fill="#21AC94" />
                    <path
                      d="M20.2497 55.6629C19.9272 55.6629 19.6203 55.4831 19.4652 55.1762L17.1896 50.5782C16.9756 50.1441 17.1524 49.6202 17.5864 49.4063L21.9766 47.2329C22.4075 47.019 22.9346 47.1957 23.1485 47.6297C23.3625 48.0607 23.1857 48.5847 22.7517 48.7986L19.146 50.5845L21.0341 54.398C21.248 54.8321 21.0713 55.356 20.6373 55.5699C20.5133 55.6319 20.3799 55.6629 20.2498 55.6629H20.2497Z"
                      fill="#21AC94" />
                    <path
                      d="M11.3641 8.76593C10.6448 8.76593 9.92544 9.03882 9.37977 9.58756C8.84963 10.1177 8.55815 10.8215 8.55815 11.5687C8.55815 12.322 8.84963 13.0227 9.37977 13.5529C10.4711 14.6443 12.2538 14.6443 13.3482 13.5529C13.8753 13.0228 14.1667 12.322 14.1667 11.5687C14.1667 10.8214 13.8752 10.1177 13.3482 9.58756C12.7995 9.03882 12.0802 8.76593 11.3641 8.76593ZM11.3641 16.1201C10.1952 16.1201 9.02945 15.6768 8.14274 14.79C7.28393 13.9312 6.80957 12.7871 6.80957 11.5687C6.80957 10.3502 7.28393 9.20923 8.14274 8.35042C9.91932 6.57395 12.8088 6.57395 14.5854 8.35042C14.5823 8.35042 16.3619 10.1269 14.5854 8.35042C15.4442 9.20923 15.9155 10.3533 15.9155 11.5687C15.9155 12.784 15.4442 13.9312 14.5854 14.79C13.6956 15.6767 12.5298 16.1201 11.3641 16.1201Z"
                      fill="#21AC94" />
                    <path
                      d="M45.2885 42.6907C44.5692 42.6907 43.8531 42.9667 43.3074 43.5123C42.7741 44.0425 42.4827 44.7494 42.4827 45.4966C42.4827 46.2439 42.7742 46.9476 43.3043 47.4777C43.8345 48.0079 44.5383 48.2994 45.2886 48.2994C46.0389 48.2994 46.7426 48.0079 47.2729 47.4808C47.803 46.9476 48.0945 46.2468 48.0945 45.4965C48.0945 44.7462 47.803 44.0425 47.2729 43.5122C46.7241 42.9666 46.008 42.6906 45.2886 42.6906L45.2885 42.6907ZM45.2885 50.051C44.0731 50.051 42.9291 49.5736 42.0702 48.7148C41.2084 47.8559 40.734 46.7151 40.734 45.4997C40.734 44.2843 41.2084 43.1372 42.0702 42.2753C43.8437 40.4987 46.7332 40.4987 48.5098 42.2753C49.3686 43.1372 49.843 44.2812 49.843 45.4997C49.843 46.7181 49.3686 47.8559 48.5067 48.7148C47.651 49.5736 46.507 50.051 45.2885 50.051Z"
                      fill="#21AC94" />
                  </svg>
                </div>
                <h5 class="mb-24">Happy Routine </h5>
                <p class="pb-22">At our daycare, we firmly believe that every child deserves a safe, nurturing, and
                  enjoyable environmen.</p>
              </div>
              <div class="num-icon">
                <h5 class="color-primary">04</h5>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- Our Work Section End -->

    <!-- Testimonial Section Start -->
    <section class="testimonial-sec mb-120 wow fadeInUp animated" data-wow-delay="500ms">
      <div class="container-fluid">
        <div class="testimonial-wrapper">
          <img class="bg-testimonial" src="assets/media/images/testimonial-bg.webp" alt="">
          <img class="bg-testimonial b2" src="assets/media/images/testimonial-bg2.webp" alt="">
          <img class="bg-testimonial b3" src="assets/media/images/testimonial-bg3.webp" alt="">
          <div class="testimonial-slider row">
            <div class="testimonial-content col-12">
              <div class="mb-50">
                <svg xmlns="http://www.w3.org/2000/svg" width="64" height="51" viewBox="0 0 64 51" fill="none">
                  <path
                    d="M3.94088 50.6011V39.8819H10.0887C14.9228 39.8819 17.3399 37.4648 17.3399 32.6306V27.5863H14.6601C10.4565 27.5863 6.98851 26.3252 4.25615 23.803C1.41872 21.2809 0 18.0756 0 14.1873C0 9.98367 1.41872 6.56823 4.25615 3.94097C6.98851 1.31371 10.4565 8.01086e-05 14.6601 8.01086e-05C18.9688 8.01086e-05 22.4893 1.31371 25.2217 3.94097C27.954 6.67332 29.3202 10.2989 29.3202 14.8178V32.9459C29.3202 44.716 23.4351 50.6011 11.665 50.6011H3.94088ZM38.6207 50.6011V39.8819H44.7685C49.6026 39.8819 52.0197 37.4648 52.0197 32.6306V27.5863H49.3399C45.1363 27.5863 41.6683 26.3252 38.936 23.803C36.0985 21.2809 34.6798 18.0756 34.6798 14.1873C34.6798 9.98367 36.0985 6.56823 38.936 3.94097C41.6683 1.31371 45.1363 8.01086e-05 49.3399 8.01086e-05C53.6486 8.01086e-05 57.1691 1.31371 59.9015 3.94097C62.6338 6.67332 64 10.2989 64 14.8178V32.9459C64 44.716 58.1149 50.6011 46.3448 50.6011H38.6207Z"
                    fill="#21AC94" />
                </svg>
              </div>
              <h4 class="mb-24">Parents' words are the key<br class="d-xl-block d-none">
                to happy kids</h4>
              <p class="mb-36 black">Flexible Classes refers to the process of acquiring knowledge or skills through the
                use of digital technologies and the internet. Flexible Classes refers to the process
                flexible Classes refers to the process.</p>
              <div class="user-block d-flex align-items-center gap-16">
                <img src="assets/media/user/user-1.webp" class="user-01" alt="user-01">
                <div>
                  <h6 class="mb-4p">Alexander Miller</h6>
                  <p class="mb-8">Parent</p>
                  <div class="d-flex gap-8 align-items-center">
                    <p class="fw-500">5.0</p>
                    <div class="d-flex align-items-center">
                      <svg xmlns="http://www.w3.org/2000/svg" width="17" height="17" viewBox="0 0 17 17" fill="none">
                        <path
                          d="M7.95211 0.475158C8.10114 0.0131588 8.75478 0.0131575 8.90382 0.475157L10.5452 5.56333C10.6118 5.76985 10.804 5.90983 11.021 5.90983H16.3401C16.8236 5.90983 17.0256 6.52779 16.6354 6.81332L12.326 9.96706C12.152 10.0944 12.0792 10.3189 12.1454 10.5241L13.79 15.6223C13.9388 16.0836 13.41 16.4656 13.0188 16.1793L8.72324 13.0358C8.54742 12.9071 8.30851 12.9071 8.13268 13.0358L3.83708 16.1793C3.44593 16.4656 2.91714 16.0836 3.06594 15.6223L4.71054 10.5241C4.77673 10.3189 4.70395 10.0944 4.52997 9.96706L0.220503 6.81332C-0.169664 6.52779 0.0323019 5.90983 0.515788 5.90983H5.83491C6.05192 5.90983 6.24415 5.76986 6.31077 5.56333L7.95211 0.475158Z"
                          fill="#FD961E" />
                      </svg>
                      <svg xmlns="http://www.w3.org/2000/svg" width="17" height="17" viewBox="0 0 17 17" fill="none">
                        <path
                          d="M7.95211 0.475158C8.10114 0.0131588 8.75478 0.0131575 8.90382 0.475157L10.5452 5.56333C10.6118 5.76985 10.804 5.90983 11.021 5.90983H16.3401C16.8236 5.90983 17.0256 6.52779 16.6354 6.81332L12.326 9.96706C12.152 10.0944 12.0792 10.3189 12.1454 10.5241L13.79 15.6223C13.9388 16.0836 13.41 16.4656 13.0188 16.1793L8.72324 13.0358C8.54742 12.9071 8.30851 12.9071 8.13268 13.0358L3.83708 16.1793C3.44593 16.4656 2.91714 16.0836 3.06594 15.6223L4.71054 10.5241C4.77673 10.3189 4.70395 10.0944 4.52997 9.96706L0.220503 6.81332C-0.169664 6.52779 0.0323019 5.90983 0.515788 5.90983H5.83491C6.05192 5.90983 6.24415 5.76986 6.31077 5.56333L7.95211 0.475158Z"
                          fill="#FD961E" />
                      </svg>
                      <svg xmlns="http://www.w3.org/2000/svg" width="17" height="17" viewBox="0 0 17 17" fill="none">
                        <path
                          d="M7.95211 0.475158C8.10114 0.0131588 8.75478 0.0131575 8.90382 0.475157L10.5452 5.56333C10.6118 5.76985 10.804 5.90983 11.021 5.90983H16.3401C16.8236 5.90983 17.0256 6.52779 16.6354 6.81332L12.326 9.96706C12.152 10.0944 12.0792 10.3189 12.1454 10.5241L13.79 15.6223C13.9388 16.0836 13.41 16.4656 13.0188 16.1793L8.72324 13.0358C8.54742 12.9071 8.30851 12.9071 8.13268 13.0358L3.83708 16.1793C3.44593 16.4656 2.91714 16.0836 3.06594 15.6223L4.71054 10.5241C4.77673 10.3189 4.70395 10.0944 4.52997 9.96706L0.220503 6.81332C-0.169664 6.52779 0.0323019 5.90983 0.515788 5.90983H5.83491C6.05192 5.90983 6.24415 5.76986 6.31077 5.56333L7.95211 0.475158Z"
                          fill="#FD961E" />
                      </svg>
                      <svg xmlns="http://www.w3.org/2000/svg" width="17" height="17" viewBox="0 0 17 17" fill="none">
                        <path
                          d="M7.95211 0.475158C8.10114 0.0131588 8.75478 0.0131575 8.90382 0.475157L10.5452 5.56333C10.6118 5.76985 10.804 5.90983 11.021 5.90983H16.3401C16.8236 5.90983 17.0256 6.52779 16.6354 6.81332L12.326 9.96706C12.152 10.0944 12.0792 10.3189 12.1454 10.5241L13.79 15.6223C13.9388 16.0836 13.41 16.4656 13.0188 16.1793L8.72324 13.0358C8.54742 12.9071 8.30851 12.9071 8.13268 13.0358L3.83708 16.1793C3.44593 16.4656 2.91714 16.0836 3.06594 15.6223L4.71054 10.5241C4.77673 10.3189 4.70395 10.0944 4.52997 9.96706L0.220503 6.81332C-0.169664 6.52779 0.0323019 5.90983 0.515788 5.90983H5.83491C6.05192 5.90983 6.24415 5.76986 6.31077 5.56333L7.95211 0.475158Z"
                          fill="#FD961E" />
                      </svg>
                      <svg xmlns="http://www.w3.org/2000/svg" width="17" height="17" viewBox="0 0 17 17" fill="none">
                        <path
                          d="M7.95211 0.475158C8.10114 0.0131588 8.75478 0.0131575 8.90382 0.475157L10.5452 5.56333C10.6118 5.76985 10.804 5.90983 11.021 5.90983H16.3401C16.8236 5.90983 17.0256 6.52779 16.6354 6.81332L12.326 9.96706C12.152 10.0944 12.0792 10.3189 12.1454 10.5241L13.79 15.6223C13.9388 16.0836 13.41 16.4656 13.0188 16.1793L8.72324 13.0358C8.54742 12.9071 8.30851 12.9071 8.13268 13.0358L3.83708 16.1793C3.44593 16.4656 2.91714 16.0836 3.06594 15.6223L4.71054 10.5241C4.77673 10.3189 4.70395 10.0944 4.52997 9.96706L0.220503 6.81332C-0.169664 6.52779 0.0323019 5.90983 0.515788 5.90983H5.83491C6.05192 5.90983 6.24415 5.76986 6.31077 5.56333L7.95211 0.475158Z"
                          fill="#FD961E" />
                      </svg>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="testimonial-content col-12">
              <div class="mb-50">
                <svg xmlns="http://www.w3.org/2000/svg" width="64" height="51" viewBox="0 0 64 51" fill="none">
                  <path
                    d="M3.94088 50.6011V39.8819H10.0887C14.9228 39.8819 17.3399 37.4648 17.3399 32.6306V27.5863H14.6601C10.4565 27.5863 6.98851 26.3252 4.25615 23.803C1.41872 21.2809 0 18.0756 0 14.1873C0 9.98367 1.41872 6.56823 4.25615 3.94097C6.98851 1.31371 10.4565 8.01086e-05 14.6601 8.01086e-05C18.9688 8.01086e-05 22.4893 1.31371 25.2217 3.94097C27.954 6.67332 29.3202 10.2989 29.3202 14.8178V32.9459C29.3202 44.716 23.4351 50.6011 11.665 50.6011H3.94088ZM38.6207 50.6011V39.8819H44.7685C49.6026 39.8819 52.0197 37.4648 52.0197 32.6306V27.5863H49.3399C45.1363 27.5863 41.6683 26.3252 38.936 23.803C36.0985 21.2809 34.6798 18.0756 34.6798 14.1873C34.6798 9.98367 36.0985 6.56823 38.936 3.94097C41.6683 1.31371 45.1363 8.01086e-05 49.3399 8.01086e-05C53.6486 8.01086e-05 57.1691 1.31371 59.9015 3.94097C62.6338 6.67332 64 10.2989 64 14.8178V32.9459C64 44.716 58.1149 50.6011 46.3448 50.6011H38.6207Z"
                    fill="#21AC94" />
                </svg>
              </div>
              <h4 class="mb-24">Parents' words are the key<br class="d-xl-block d-none">
                to happy kids</h4>
              <p class="mb-36 black">Flexible Classes refers to the process of acquiring knowledge or skills through the
                use of digital technologies and the internet. Flexible Classes refers to the process
                flexible Classes refers to the process.</p>
              <div class="user-block d-flex align-items-center gap-16">
                <img src="assets/media/user/user-1.webp" class="user-01" alt="user-01">
                <div>
                  <h6 class="mb-4p">Alexander Miller</h6>
                  <p class="mb-8">Parent</p>
                  <div class="d-flex gap-8 align-items-center">
                    <p class="fw-500">5.0</p>
                    <div class="d-flex align-items-center">
                      <svg xmlns="http://www.w3.org/2000/svg" width="17" height="17" viewBox="0 0 17 17" fill="none">
                        <path
                          d="M7.95211 0.475158C8.10114 0.0131588 8.75478 0.0131575 8.90382 0.475157L10.5452 5.56333C10.6118 5.76985 10.804 5.90983 11.021 5.90983H16.3401C16.8236 5.90983 17.0256 6.52779 16.6354 6.81332L12.326 9.96706C12.152 10.0944 12.0792 10.3189 12.1454 10.5241L13.79 15.6223C13.9388 16.0836 13.41 16.4656 13.0188 16.1793L8.72324 13.0358C8.54742 12.9071 8.30851 12.9071 8.13268 13.0358L3.83708 16.1793C3.44593 16.4656 2.91714 16.0836 3.06594 15.6223L4.71054 10.5241C4.77673 10.3189 4.70395 10.0944 4.52997 9.96706L0.220503 6.81332C-0.169664 6.52779 0.0323019 5.90983 0.515788 5.90983H5.83491C6.05192 5.90983 6.24415 5.76986 6.31077 5.56333L7.95211 0.475158Z"
                          fill="#FD961E" />
                      </svg>
                      <svg xmlns="http://www.w3.org/2000/svg" width="17" height="17" viewBox="0 0 17 17" fill="none">
                        <path
                          d="M7.95211 0.475158C8.10114 0.0131588 8.75478 0.0131575 8.90382 0.475157L10.5452 5.56333C10.6118 5.76985 10.804 5.90983 11.021 5.90983H16.3401C16.8236 5.90983 17.0256 6.52779 16.6354 6.81332L12.326 9.96706C12.152 10.0944 12.0792 10.3189 12.1454 10.5241L13.79 15.6223C13.9388 16.0836 13.41 16.4656 13.0188 16.1793L8.72324 13.0358C8.54742 12.9071 8.30851 12.9071 8.13268 13.0358L3.83708 16.1793C3.44593 16.4656 2.91714 16.0836 3.06594 15.6223L4.71054 10.5241C4.77673 10.3189 4.70395 10.0944 4.52997 9.96706L0.220503 6.81332C-0.169664 6.52779 0.0323019 5.90983 0.515788 5.90983H5.83491C6.05192 5.90983 6.24415 5.76986 6.31077 5.56333L7.95211 0.475158Z"
                          fill="#FD961E" />
                      </svg>
                      <svg xmlns="http://www.w3.org/2000/svg" width="17" height="17" viewBox="0 0 17 17" fill="none">
                        <path
                          d="M7.95211 0.475158C8.10114 0.0131588 8.75478 0.0131575 8.90382 0.475157L10.5452 5.56333C10.6118 5.76985 10.804 5.90983 11.021 5.90983H16.3401C16.8236 5.90983 17.0256 6.52779 16.6354 6.81332L12.326 9.96706C12.152 10.0944 12.0792 10.3189 12.1454 10.5241L13.79 15.6223C13.9388 16.0836 13.41 16.4656 13.0188 16.1793L8.72324 13.0358C8.54742 12.9071 8.30851 12.9071 8.13268 13.0358L3.83708 16.1793C3.44593 16.4656 2.91714 16.0836 3.06594 15.6223L4.71054 10.5241C4.77673 10.3189 4.70395 10.0944 4.52997 9.96706L0.220503 6.81332C-0.169664 6.52779 0.0323019 5.90983 0.515788 5.90983H5.83491C6.05192 5.90983 6.24415 5.76986 6.31077 5.56333L7.95211 0.475158Z"
                          fill="#FD961E" />
                      </svg>
                      <svg xmlns="http://www.w3.org/2000/svg" width="17" height="17" viewBox="0 0 17 17" fill="none">
                        <path
                          d="M7.95211 0.475158C8.10114 0.0131588 8.75478 0.0131575 8.90382 0.475157L10.5452 5.56333C10.6118 5.76985 10.804 5.90983 11.021 5.90983H16.3401C16.8236 5.90983 17.0256 6.52779 16.6354 6.81332L12.326 9.96706C12.152 10.0944 12.0792 10.3189 12.1454 10.5241L13.79 15.6223C13.9388 16.0836 13.41 16.4656 13.0188 16.1793L8.72324 13.0358C8.54742 12.9071 8.30851 12.9071 8.13268 13.0358L3.83708 16.1793C3.44593 16.4656 2.91714 16.0836 3.06594 15.6223L4.71054 10.5241C4.77673 10.3189 4.70395 10.0944 4.52997 9.96706L0.220503 6.81332C-0.169664 6.52779 0.0323019 5.90983 0.515788 5.90983H5.83491C6.05192 5.90983 6.24415 5.76986 6.31077 5.56333L7.95211 0.475158Z"
                          fill="#FD961E" />
                      </svg>
                      <svg xmlns="http://www.w3.org/2000/svg" width="17" height="17" viewBox="0 0 17 17" fill="none">
                        <path
                          d="M7.95211 0.475158C8.10114 0.0131588 8.75478 0.0131575 8.90382 0.475157L10.5452 5.56333C10.6118 5.76985 10.804 5.90983 11.021 5.90983H16.3401C16.8236 5.90983 17.0256 6.52779 16.6354 6.81332L12.326 9.96706C12.152 10.0944 12.0792 10.3189 12.1454 10.5241L13.79 15.6223C13.9388 16.0836 13.41 16.4656 13.0188 16.1793L8.72324 13.0358C8.54742 12.9071 8.30851 12.9071 8.13268 13.0358L3.83708 16.1793C3.44593 16.4656 2.91714 16.0836 3.06594 15.6223L4.71054 10.5241C4.77673 10.3189 4.70395 10.0944 4.52997 9.96706L0.220503 6.81332C-0.169664 6.52779 0.0323019 5.90983 0.515788 5.90983H5.83491C6.05192 5.90983 6.24415 5.76986 6.31077 5.56333L7.95211 0.475158Z"
                          fill="#FD961E" />
                      </svg>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="slider-arrows">
            <a href="javascript:;" class="arrow-btn btn-prev" data-slide="testimonial-slider">
              <svg xmlns="http://www.w3.org/2000/svg" width="27" height="21" viewBox="0 0 27 21" fill="none">
                <path d="M25.5004 10.5H1.50037M1.50037 10.5L10.5004 19.5M1.50037 10.5L10.5004 1.5" stroke="#0C0C0D"
                  stroke-width="3" stroke-linecap="round" stroke-linejoin="round" />
              </svg>
            </a>
            <a href="javascript:;" class="arrow-btn btn-next" data-slide="testimonial-slider">
              <svg xmlns="http://www.w3.org/2000/svg" width="27" height="21" viewBox="0 0 27 21" fill="none">
                <path d="M1.49963 10.5H25.4996M25.4996 10.5L16.4996 19.5M25.4996 10.5L16.4996 1.5" stroke="#FAFAFA"
                  stroke-width="3" stroke-linecap="round" stroke-linejoin="round" />
              </svg>
            </a>
          </div>
        </div>
      </div>
    </section>
    <!-- Testimonial Section End -->

    <!-- Blog Section Start -->
    <section class="blog-sec mb-120">
      <div class="container-fluid">
        <div class="heading mb-48">
          <div>
            <h2 class="mb-16">Know more about <span class="color-primary">kids</span></h2>
            <p>At our daycare, we firmly believe that every child deserves a safe, nurturing, and enjoyable environmen.
            </p>
          </div>
          <div>
            <a href="blogs.php" class="cus-btn">
              <span class="icon">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                  <g clip-path="url(#clip0_13590_1786)">
                    <path
                      d="M15.2478 0.439753C15.1203 0.312229 14.9291 0.273016 14.7618 0.339963L0.278578 6.13316C0.112863 6.19945 0.00189545 6.35726 -0.00447473 6.53565C-0.0108149 6.71402 0.0887042 6.87931 0.249281 6.9572L5.96045 9.72705L8.73033 15.4382C8.80587 15.594 8.96363 15.6923 9.13577 15.6923C9.14112 15.6923 9.1465 15.6922 9.15188 15.692C9.33021 15.6856 9.48809 15.5747 9.55434 15.409L15.3476 0.92587C15.4145 0.758442 15.3753 0.567246 15.2478 0.439753ZM1.56055 6.59127L13.0577 1.99245L6.20588 8.84421L1.56055 6.59127ZM9.09626 14.127L6.84329 9.48159L13.6951 2.62983L9.09626 14.127Z"
                      fill="#F7B631" />
                  </g>
                  <defs>
                    <clipPath>
                      <rect width="15.3846" height="15.3846" fill="white" transform="translate(-0.00463867 0.307693)" />
                    </clipPath>
                  </defs>
                </svg>
              </span>
              <span class="text">Discover More</span>
            </a>
          </div>
        </div>
        <div class="row row-gap-4">
          <div class="col-xxl-3 col-lg-4 col-md-6 wow fadeInUp animated" data-wow-delay="400ms">
            <div class="blog-card">
              <a href="blog-detail.php" class="card-img">
                <img src="assets/media/blogs/img01.webp" alt="img1">
              </a>
              <div class="card-content">
                <div class="d-flex align-items-center gap-14 mb-16">
                  <div class="d-flex align-items-center gap-4">
                    <svg class="svg" xmlns="http://www.w3.org/2000/svg" width="20" height="21" viewBox="0 0 20 21"
                      fill="none">
                      <path
                        d="M17.5 8.71745H2.5M13.3333 2.05078V5.38411M6.66667 2.05078V5.38411M6.5 18.7174H13.5C14.9001 18.7174 15.6002 18.7174 16.135 18.445C16.6054 18.2053 16.9878 17.8228 17.2275 17.3524C17.5 16.8176 17.5 16.1176 17.5 14.7174V7.71745C17.5 6.31732 17.5 5.61725 17.2275 5.08247C16.9878 4.61207 16.6054 4.22961 16.135 3.98993C15.6002 3.71745 14.9001 3.71745 13.5 3.71745H6.5C5.09987 3.71745 4.3998 3.71745 3.86502 3.98993C3.39462 4.22961 3.01217 4.61207 2.77248 5.08247C2.5 5.61725 2.5 6.31732 2.5 7.71745V14.7174C2.5 16.1176 2.5 16.8176 2.77248 17.3524C3.01217 17.8228 3.39462 18.2053 3.86502 18.445C4.3998 18.7174 5.09987 18.7174 6.5 18.7174Z"
                        stroke="#21AC94" stroke-width="1.66667" stroke-linecap="round" stroke-linejoin="round" />
                    </svg>
                    <p>2nd May 2025</p>
                  </div>
                  <p>|</p>
                  <div class="d-flex align-items-center gap-4">
                    <svg class="svg" xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21"
                      fill="none">
                      <path
                        d="M10.4857 5.38411V10.3841L13.819 12.0508M18.819 10.3841C18.819 14.9865 15.0881 18.7174 10.4857 18.7174C5.88333 18.7174 2.15237 14.9865 2.15237 10.3841C2.15237 5.78174 5.88333 2.05078 10.4857 2.05078C15.0881 2.05078 18.819 5.78174 18.819 10.3841Z"
                        stroke="#21AC94" stroke-width="1.66667" stroke-linecap="round" stroke-linejoin="round" />
                    </svg>
                    <p>5 min read</p>
                  </div>
                </div>
                <a href="blog-detail.php" class="h5 hover-content mb-12">The Importance of Early Education</a>
                <p class="mb-16">At our daycare, we firmly believe that every child deserves a safe, nurturing, and
                  enjoyabl...</p>
                <div>
                  <a href="blog-detail.php" class="cus-btn">
                    <span class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                        <g clip-path="url(#clip0_13590_1786)">
                          <path
                            d="M15.2478 0.439753C15.1203 0.312229 14.9291 0.273016 14.7618 0.339963L0.278578 6.13316C0.112863 6.19945 0.00189545 6.35726 -0.00447473 6.53565C-0.0108149 6.71402 0.0887042 6.87931 0.249281 6.9572L5.96045 9.72705L8.73033 15.4382C8.80587 15.594 8.96363 15.6923 9.13577 15.6923C9.14112 15.6923 9.1465 15.6922 9.15188 15.692C9.33021 15.6856 9.48809 15.5747 9.55434 15.409L15.3476 0.92587C15.4145 0.758442 15.3753 0.567246 15.2478 0.439753ZM1.56055 6.59127L13.0577 1.99245L6.20588 8.84421L1.56055 6.59127ZM9.09626 14.127L6.84329 9.48159L13.6951 2.62983L9.09626 14.127Z"
                            fill="#F7B631" />
                        </g>
                        <defs>
                          <clipPath>
                            <rect width="15.3846" height="15.3846" fill="white"
                              transform="translate(-0.00463867 0.307693)" />
                          </clipPath>
                        </defs>
                      </svg>
                    </span>
                    <span class="text">Read More</span>
                  </a>
                </div>
              </div>
            </div>
          </div>
          <div class="col-xxl-3 col-lg-4 col-md-6 wow fadeInUp animated" data-wow-delay="550ms">
            <div class="blog-card">
              <a href="blog-detail.php" class="card-img">
                <img src="assets/media/blogs/img02.webp" alt="img1">
              </a>
              <div class="card-content">
                <div class="d-flex align-items-center gap-14 mb-16">
                  <div class="d-flex align-items-center gap-4">
                    <svg class="svg" xmlns="http://www.w3.org/2000/svg" width="20" height="21" viewBox="0 0 20 21"
                      fill="none">
                      <path
                        d="M17.5 8.71745H2.5M13.3333 2.05078V5.38411M6.66667 2.05078V5.38411M6.5 18.7174H13.5C14.9001 18.7174 15.6002 18.7174 16.135 18.445C16.6054 18.2053 16.9878 17.8228 17.2275 17.3524C17.5 16.8176 17.5 16.1176 17.5 14.7174V7.71745C17.5 6.31732 17.5 5.61725 17.2275 5.08247C16.9878 4.61207 16.6054 4.22961 16.135 3.98993C15.6002 3.71745 14.9001 3.71745 13.5 3.71745H6.5C5.09987 3.71745 4.3998 3.71745 3.86502 3.98993C3.39462 4.22961 3.01217 4.61207 2.77248 5.08247C2.5 5.61725 2.5 6.31732 2.5 7.71745V14.7174C2.5 16.1176 2.5 16.8176 2.77248 17.3524C3.01217 17.8228 3.39462 18.2053 3.86502 18.445C4.3998 18.7174 5.09987 18.7174 6.5 18.7174Z"
                        stroke="#21AC94" stroke-width="1.66667" stroke-linecap="round" stroke-linejoin="round" />
                    </svg>
                    <p>2nd May 2025</p>
                  </div>
                  <p>|</p>
                  <div class="d-flex align-items-center gap-4">
                    <svg class="svg" xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21"
                      fill="none">
                      <path
                        d="M10.4857 5.38411V10.3841L13.819 12.0508M18.819 10.3841C18.819 14.9865 15.0881 18.7174 10.4857 18.7174C5.88333 18.7174 2.15237 14.9865 2.15237 10.3841C2.15237 5.78174 5.88333 2.05078 10.4857 2.05078C15.0881 2.05078 18.819 5.78174 18.819 10.3841Z"
                        stroke="#21AC94" stroke-width="1.66667" stroke-linecap="round" stroke-linejoin="round" />
                    </svg>
                    <p>5 min read</p>
                  </div>
                </div>
                <a href="blog-detail.php" class="h5 hover-content mb-12">How to Choose the Best Daycare for Your
                  Child</a>
                <p class="mb-16">At our daycare, we firmly believe that every child deserves a safe, nurturing, and
                  enjoyabl...</p>
                <div>
                  <a href="blog-detail.php" class="cus-btn">
                    <span class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                        <g clip-path="url(#clip0_13590_1786)">
                          <path
                            d="M15.2478 0.439753C15.1203 0.312229 14.9291 0.273016 14.7618 0.339963L0.278578 6.13316C0.112863 6.19945 0.00189545 6.35726 -0.00447473 6.53565C-0.0108149 6.71402 0.0887042 6.87931 0.249281 6.9572L5.96045 9.72705L8.73033 15.4382C8.80587 15.594 8.96363 15.6923 9.13577 15.6923C9.14112 15.6923 9.1465 15.6922 9.15188 15.692C9.33021 15.6856 9.48809 15.5747 9.55434 15.409L15.3476 0.92587C15.4145 0.758442 15.3753 0.567246 15.2478 0.439753ZM1.56055 6.59127L13.0577 1.99245L6.20588 8.84421L1.56055 6.59127ZM9.09626 14.127L6.84329 9.48159L13.6951 2.62983L9.09626 14.127Z"
                            fill="#F7B631" />
                        </g>
                        <defs>
                          <clipPath>
                            <rect width="15.3846" height="15.3846" fill="white"
                              transform="translate(-0.00463867 0.307693)" />
                          </clipPath>
                        </defs>
                      </svg>
                    </span>
                    <span class="text">Read More</span>
                  </a>
                </div>
              </div>
            </div>
          </div>
          <div class="col-xxl-3 col-lg-4 col-md-6 wow fadeInUp animated" data-wow-delay="750ms">
            <div class="blog-card">
              <a href="blog-detail.php" class="card-img">
                <img src="assets/media/blogs/img03.webp" alt="img1">
              </a>
              <div class="card-content">
                <div class="d-flex align-items-center gap-14 mb-16">
                  <div class="d-flex align-items-center gap-4">
                    <svg class="svg" xmlns="http://www.w3.org/2000/svg" width="20" height="21" viewBox="0 0 20 21"
                      fill="none">
                      <path
                        d="M17.5 8.71745H2.5M13.3333 2.05078V5.38411M6.66667 2.05078V5.38411M6.5 18.7174H13.5C14.9001 18.7174 15.6002 18.7174 16.135 18.445C16.6054 18.2053 16.9878 17.8228 17.2275 17.3524C17.5 16.8176 17.5 16.1176 17.5 14.7174V7.71745C17.5 6.31732 17.5 5.61725 17.2275 5.08247C16.9878 4.61207 16.6054 4.22961 16.135 3.98993C15.6002 3.71745 14.9001 3.71745 13.5 3.71745H6.5C5.09987 3.71745 4.3998 3.71745 3.86502 3.98993C3.39462 4.22961 3.01217 4.61207 2.77248 5.08247C2.5 5.61725 2.5 6.31732 2.5 7.71745V14.7174C2.5 16.1176 2.5 16.8176 2.77248 17.3524C3.01217 17.8228 3.39462 18.2053 3.86502 18.445C4.3998 18.7174 5.09987 18.7174 6.5 18.7174Z"
                        stroke="#21AC94" stroke-width="1.66667" stroke-linecap="round" stroke-linejoin="round" />
                    </svg>
                    <p>2nd May 2025</p>
                  </div>
                  <p>|</p>
                  <div class="d-flex align-items-center gap-4">
                    <svg class="svg" xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21"
                      fill="none">
                      <path
                        d="M10.4857 5.38411V10.3841L13.819 12.0508M18.819 10.3841C18.819 14.9865 15.0881 18.7174 10.4857 18.7174C5.88333 18.7174 2.15237 14.9865 2.15237 10.3841C2.15237 5.78174 5.88333 2.05078 10.4857 2.05078C15.0881 2.05078 18.819 5.78174 18.819 10.3841Z"
                        stroke="#21AC94" stroke-width="1.66667" stroke-linecap="round" stroke-linejoin="round" />
                    </svg>
                    <p>5 min read</p>
                  </div>
                </div>
                <a href="blog-detail.php" class="h5 hover-content mb-12">5 Fun & Educational Indoor Activities</a>
                <p class="mb-16">At our daycare, we firmly believe that every child deserves a safe, nurturing, and
                  enjoyabl...</p>
                <div>
                  <a href="blog-detail.php" class="cus-btn">
                    <span class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                        <g clip-path="url(#clip0_13590_1786)">
                          <path
                            d="M15.2478 0.439753C15.1203 0.312229 14.9291 0.273016 14.7618 0.339963L0.278578 6.13316C0.112863 6.19945 0.00189545 6.35726 -0.00447473 6.53565C-0.0108149 6.71402 0.0887042 6.87931 0.249281 6.9572L5.96045 9.72705L8.73033 15.4382C8.80587 15.594 8.96363 15.6923 9.13577 15.6923C9.14112 15.6923 9.1465 15.6922 9.15188 15.692C9.33021 15.6856 9.48809 15.5747 9.55434 15.409L15.3476 0.92587C15.4145 0.758442 15.3753 0.567246 15.2478 0.439753ZM1.56055 6.59127L13.0577 1.99245L6.20588 8.84421L1.56055 6.59127ZM9.09626 14.127L6.84329 9.48159L13.6951 2.62983L9.09626 14.127Z"
                            fill="#F7B631" />
                        </g>
                        <defs>
                          <clipPath>
                            <rect width="15.3846" height="15.3846" fill="white"
                              transform="translate(-0.00463867 0.307693)" />
                          </clipPath>
                        </defs>
                      </svg>
                    </span>
                    <span class="text">Read More</span>
                  </a>
                </div>
              </div>
            </div>
          </div>
          <div class="col-xxl-3 col-lg-4 col-md-6 d-xxl-block d-lg-none wow fadeInUp animated" data-wow-delay="900ms">
            <div class="blog-card">
              <a href="blog-detail.php" class="card-img">
                <img src="assets/media/blogs/img04.webp" alt="img1">
              </a>
              <div class="card-content">
                <div class="d-flex align-items-center gap-14 mb-16">
                  <div class="d-flex align-items-center gap-4">
                    <svg class="svg" xmlns="http://www.w3.org/2000/svg" width="20" height="21" viewBox="0 0 20 21"
                      fill="none">
                      <path
                        d="M17.5 8.71745H2.5M13.3333 2.05078V5.38411M6.66667 2.05078V5.38411M6.5 18.7174H13.5C14.9001 18.7174 15.6002 18.7174 16.135 18.445C16.6054 18.2053 16.9878 17.8228 17.2275 17.3524C17.5 16.8176 17.5 16.1176 17.5 14.7174V7.71745C17.5 6.31732 17.5 5.61725 17.2275 5.08247C16.9878 4.61207 16.6054 4.22961 16.135 3.98993C15.6002 3.71745 14.9001 3.71745 13.5 3.71745H6.5C5.09987 3.71745 4.3998 3.71745 3.86502 3.98993C3.39462 4.22961 3.01217 4.61207 2.77248 5.08247C2.5 5.61725 2.5 6.31732 2.5 7.71745V14.7174C2.5 16.1176 2.5 16.8176 2.77248 17.3524C3.01217 17.8228 3.39462 18.2053 3.86502 18.445C4.3998 18.7174 5.09987 18.7174 6.5 18.7174Z"
                        stroke="#21AC94" stroke-width="1.66667" stroke-linecap="round" stroke-linejoin="round" />
                    </svg>
                    <p>2nd May 2025</p>
                  </div>
                  <p>|</p>
                  <div class="d-flex align-items-center gap-4">
                    <svg class="svg" xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21"
                      fill="none">
                      <path
                        d="M10.4857 5.38411V10.3841L13.819 12.0508M18.819 10.3841C18.819 14.9865 15.0881 18.7174 10.4857 18.7174C5.88333 18.7174 2.15237 14.9865 2.15237 10.3841C2.15237 5.78174 5.88333 2.05078 10.4857 2.05078C15.0881 2.05078 18.819 5.78174 18.819 10.3841Z"
                        stroke="#21AC94" stroke-width="1.66667" stroke-linecap="round" stroke-linejoin="round" />
                    </svg>
                    <p>5 min read</p>
                  </div>
                </div>
                <a href="blog-detail.php" class="h5 hover-content mb-12">The Benefits of Play-Based Learning in
                  Dayca</a>
                <p class="mb-16">At our daycare, we firmly believe that every child deserves a safe, nurturing, and
                  enjoyabl...</p>
                <div>
                  <a href="blog-detail.php" class="cus-btn">
                    <span class="icon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                        <g clip-path="url(#clip0_13590_1786)">
                          <path
                            d="M15.2478 0.439753C15.1203 0.312229 14.9291 0.273016 14.7618 0.339963L0.278578 6.13316C0.112863 6.19945 0.00189545 6.35726 -0.00447473 6.53565C-0.0108149 6.71402 0.0887042 6.87931 0.249281 6.9572L5.96045 9.72705L8.73033 15.4382C8.80587 15.594 8.96363 15.6923 9.13577 15.6923C9.14112 15.6923 9.1465 15.6922 9.15188 15.692C9.33021 15.6856 9.48809 15.5747 9.55434 15.409L15.3476 0.92587C15.4145 0.758442 15.3753 0.567246 15.2478 0.439753ZM1.56055 6.59127L13.0577 1.99245L6.20588 8.84421L1.56055 6.59127ZM9.09626 14.127L6.84329 9.48159L13.6951 2.62983L9.09626 14.127Z"
                            fill="#F7B631" />
                        </g>
                        <defs>
                          <clipPath>
                            <rect width="15.3846" height="15.3846" fill="white"
                              transform="translate(-0.00463867 0.307693)" />
                          </clipPath>
                        </defs>
                      </svg>
                    </span>
                    <span class="text">Read More</span>
                  </a>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- Blog Section End -->

    <footer>
      <div class="container-fluid">
        <div class="row row-gap-5 mb-64">
          <div class="col-sm-3 col-7">
            <a href="" class="footer-logo mb-16">
              <img src="assets/media/footer-logo.webp" alt="">
            </a>
            <p class="mb-48">At our daycare, we firmly believe that every child deserves a safe, nurturing, and
              enjoyable environment where they can play, and grow.</p>
            <div>
              <h5 class="black underline mb-24">Follow Us:</h5>
              <div class="social-icons">
                <a href="" class="icon">
                  <svg xmlns="http://www.w3.org/2000/svg" width="18" height="15" viewBox="0 0 18 15" fill="none">
                    <path
                      d="M1.23741 6.41173C6.06923 4.43602 9.29121 3.13351 10.9033 2.50421C15.5063 0.707405 16.4627 0.395282 17.0861 0.384866C17.2232 0.382709 17.5298 0.414599 17.7284 0.565828C17.8961 0.693523 17.9422 0.86602 17.9643 0.987089C17.9864 1.10816 18.0139 1.38395 17.992 1.59945C17.7426 4.05914 16.6633 10.0281 16.1142 12.783C15.8818 13.9487 15.4244 14.3396 14.9815 14.3778C14.0189 14.461 13.288 13.7808 12.3558 13.2073C10.897 12.3099 10.0729 11.7512 8.65691 10.8755C7.02048 9.86338 8.08131 9.30713 9.0139 8.39805C9.25797 8.16014 13.4988 4.53993 13.5809 4.21152C13.5912 4.17044 13.6007 4.01734 13.5038 3.9365C13.4069 3.85565 13.2639 3.8833 13.1606 3.90529C13.0143 3.93645 10.6839 5.38206 6.16938 8.24211C5.5079 8.66841 4.90875 8.87611 4.37193 8.86523C3.78013 8.85323 2.64175 8.55119 1.79548 8.29302C0.757494 7.97636 -0.0674757 7.80894 0.00436067 7.27115C0.0417775 6.99103 0.452793 6.70456 1.23741 6.41173Z"
                      fill="#FAFAFA" />
                  </svg>
                </a>
                <a href="" class="icon">
                  <svg xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17" fill="none">
                    <path fill-rule="evenodd" clip-rule="evenodd"
                      d="M13.6 2.68477C12.1 1.18477 10.1 0.384766 8 0.384766C3.6 0.384766 0 3.98477 0 8.38477C0 9.78477 0.400006 11.1848 1.10001 12.3848L0 16.3848L4.20001 15.2848C5.40001 15.8848 6.7 16.2848 8 16.2848C12.4 16.2848 16 12.6848 16 8.28477C16 6.18477 15.1 4.18477 13.6 2.68477ZM8 14.9848C6.8 14.9848 5.60001 14.6848 4.60001 14.0848L4.39999 13.9848L1.89999 14.6848L2.60001 12.2848L2.39999 11.9848C1.69999 10.8848 1.39999 9.68477 1.39999 8.48477C1.39999 4.88477 4.4 1.88477 8 1.88477C9.8 1.88477 11.4 2.58477 12.7 3.78477C14 5.08477 14.6 6.68477 14.6 8.48477C14.6 11.9848 11.7 14.9848 8 14.9848ZM11.6 9.98477C11.4 9.88477 10.4 9.38477 10.2 9.38477C10 9.28477 9.89999 9.28477 9.79999 9.48477C9.69999 9.68477 9.30001 10.0848 9.20001 10.2848C9.10001 10.3848 8.99999 10.3848 8.79999 10.3848C8.59999 10.2848 8.00001 10.0848 7.20001 9.38477C6.60001 8.88477 6.20001 8.18477 6.10001 7.98477C6.00001 7.78477 6.10001 7.68477 6.20001 7.58477C6.30001 7.48477 6.4 7.38477 6.5 7.28477C6.6 7.18477 6.60001 7.08477 6.70001 6.98477C6.80001 6.88477 6.70001 6.78477 6.70001 6.68477C6.70001 6.58477 6.30001 5.58477 6.10001 5.18477C6.00001 4.88477 5.80001 4.88477 5.70001 4.88477C5.60001 4.88477 5.49999 4.88477 5.29999 4.88477C5.19999 4.88477 4.99999 4.88477 4.79999 5.08477C4.59999 5.28477 4.10001 5.78477 4.10001 6.78477C4.10001 7.78477 4.79999 8.68477 4.89999 8.88477C4.99999 8.98477 6.29999 11.0848 8.29999 11.8848C9.99999 12.5848 10.3 12.3848 10.7 12.3848C11.1 12.3848 11.9 11.8848 12 11.4848C12.2 10.9848 12.2 10.5848 12.1 10.5848C12 10.0848 11.8 10.0848 11.6 9.98477Z"
                      fill="#21AC94" />
                  </svg>
                </a>
                <a href="" class="icon">
                  <svg xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17" fill="none">
                    <g clip-path="url(#clip0_13624_237)">
                      <path
                        d="M11.75 4.13477C12.0087 4.13477 12.2187 3.92477 12.2187 3.66602V0.853516C12.2187 0.594766 12.0087 0.384766 11.75 0.384766H8.93747C7.12809 0.384766 5.65622 1.85664 5.65622 3.66602V6.00977H4.24997C3.99122 6.00977 3.78122 6.21977 3.78122 6.47852V9.29102C3.78122 9.54977 3.99122 9.75977 4.24997 9.75977H5.65622V15.916C5.65622 16.1748 5.86622 16.3848 6.12497 16.3848H8.93747C9.19622 16.3848 9.40622 16.1748 9.40622 15.916V9.75977H11.2812C11.5103 9.75977 11.7059 9.59414 11.7437 9.3682L12.2125 6.5557C12.235 6.41977 12.1968 6.2807 12.1078 6.17539C12.0187 6.07039 11.8878 6.00977 11.75 6.00977H9.40622V4.13477H11.75ZM8.93747 6.94727H11.1965L10.884 8.82227H8.93747C8.67872 8.82227 8.46872 9.03227 8.46872 9.29102V15.4473H6.59372V9.29102C6.59372 9.03227 6.38372 8.82227 6.12497 8.82227H4.71872V6.94727H6.12497C6.38372 6.94727 6.59372 6.73727 6.59372 6.47852V3.66602C6.59372 2.37383 7.64528 1.32227 8.93747 1.32227H11.2812V3.19727H8.93747C8.67872 3.19727 8.46872 3.40727 8.46872 3.66602V6.47852C8.46872 6.73727 8.67872 6.94727 8.93747 6.94727Z"
                        fill="#21AC94" />
                    </g>
                    <defs>
                      <clipPath>
                        <rect width="16" height="16" fill="white" transform="translate(0 0.384766)" />
                      </clipPath>
                    </defs>
                  </svg>
                </a>
                <a href="" class="icon">
                  <svg xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17" fill="none">
                    <g clip-path="url(#clip0_13624_240)">
                      <path
                        d="M8.03125 16.3848C12.4353 16.3848 16 12.8207 16 8.41602C16 4.02747 12.4502 0.384766 8.03125 0.384766C3.63074 0.384766 0 4.01306 0 8.41602C0 12.8389 3.64709 16.3848 8.03125 16.3848ZM3.91821 14.1416C4.49915 11.9277 6.5686 10.1265 9.21558 9.32886C9.8363 11.1602 10.2195 13.0942 10.3358 15.059C9.61353 15.3102 8.83813 15.4473 8.03125 15.4473C6.49927 15.4473 5.0791 14.9633 3.91821 14.1416ZM11.2496 14.6663C11.1099 12.7545 10.7366 10.8895 10.1357 9.09729C11.7671 8.76538 13.4679 8.82788 15.0133 9.24585C14.7341 11.6093 13.2786 13.6173 11.2496 14.6663ZM9.2804 6.92725C10.871 6.33447 12.5574 5.35144 13.4745 3.93091C14.4419 5.12354 15.0321 6.63867 15.0609 8.28955C13.3978 7.87244 11.574 7.828 9.81482 8.203C9.64453 7.7583 9.47241 7.34875 9.2804 6.92725ZM12.8101 3.21765C12.0491 4.59412 10.3447 5.54126 8.87195 6.0791C8.04761 4.45752 7.03918 2.97827 5.86023 1.66248C6.5448 1.44189 7.27429 1.32227 8.03125 1.32227C9.87488 1.32227 11.5547 2.04224 12.8101 3.21765ZM4.93213 2.03601C6.12048 3.31628 7.13843 4.78259 7.96167 6.375C5.90564 6.96594 3.49438 7.16785 1.10535 6.88049C1.578 4.74695 3.01404 2.97156 4.93213 2.03601ZM0.963867 7.80786C3.52393 8.12 6.13599 7.89929 8.37878 7.229C8.56189 7.62634 8.73352 8.0304 8.89282 8.44067C6.31677 9.22156 3.98328 10.9808 3.13306 13.4973C1.78101 12.2163 0.9375 10.412 0.9375 8.41602C0.9375 8.21118 0.946777 8.00842 0.963867 7.80786Z"
                        fill="#21AC94" />
                    </g>
                    <defs>
                      <clipPath>
                        <rect width="16" height="16" fill="white" transform="translate(0 0.384766)" />
                      </clipPath>
                    </defs>
                  </svg>
                </a>
              </div>
            </div>
          </div>
          <div class="col-sm-3 col-5 wow fadeInUp animated" data-wow-delay="300ms">
            <div class="link-block">
              <div class="mb-24">
                <h5 class="underline l2">Our Services</h5>
              </div>
              <ul class="unstyled">
                <li><a href="service-detail.php">Auto Insurance</a></li>
                <li><a href="service-detail.php">Health Insurance</a></li>
                <li><a href="service-detail.php">Life Insurance</a></li>
                <li><a href="service-detail.php">Pet Insurance</a></li>
              </ul>
            </div>
          </div>
          <div class="col-sm-3 col-6 wow fadeInUp animated" data-wow-delay="400ms">
            <div class="link-block">
              <div class="mb-24">
                <h5 class="underline l3">Quick Links</h5>
              </div>
              <ul class="unstyled">
                <li><a href="index.php">Home</a></li>
                <li><a href="about.php">About Us</a></li>
                <li><a href="contact.php">Contact Us</a></li>
                <li><a href="blogs.php">Blogs</a></li>
              </ul>
            </div>
          </div>
          <div class="col-sm-3 col-6">
            <div class="touch-block">
              <h5 class="underline mb-24">Stay In Touch</h5>
              <div class="d-flex align-items-center gap-8 mb-16">
                <div class="svg">
                  <svg xmlns="http://www.w3.org/2000/svg" width="24" height="25" viewBox="0 0 24 25" fill="none">
                    <g clip-path="url(#clip0_13624_269)">
                      <path
                        d="M12 0.384766C7.58889 0.384766 4 3.97366 4 8.38478C4 9.709 4.33108 11.022 4.96047 12.1865L11.5625 24.127C11.6504 24.2861 11.8179 24.3848 12 24.3848C12.1821 24.3848 12.3496 24.2861 12.4375 24.127L19.042 12.1826C19.669 11.022 20 9.70895 20 8.38473C20 3.97366 16.4111 0.384766 12 0.384766ZM12 12.3848C9.79445 12.3848 8.00003 10.5903 8.00003 8.38478C8.00003 6.17922 9.79445 4.3848 12 4.3848C14.2056 4.3848 16 6.17922 16 8.38478C16 10.5903 14.2056 12.3848 12 12.3848Z"
                        fill="#21AC94" />
                    </g>
                    <defs>
                      <clipPath>
                        <rect width="24" height="24" fill="white" transform="translate(0 0.384766)" />
                      </clipPath>
                    </defs>
                  </svg>
                </div>
                <p>216 Main Boulevard, New York City</p>
              </div>
              <div class="d-flex align-items-center gap-8 mb-16">
                <div class="svg">
                  <svg xmlns="http://www.w3.org/2000/svg" width="24" height="25" viewBox="0 0 24 25" fill="none">
                    <g clip-path="url(#clip0_13624_276)">
                      <path
                        d="M23.3475 17.9983L19.9982 14.6491C18.802 13.4529 16.7685 13.9314 16.2901 15.4864C15.9312 16.563 14.7351 17.1611 13.6585 16.9218C11.2662 16.3237 8.03651 13.2137 7.43842 10.7017C7.07957 9.62512 7.79727 8.42895 8.87383 8.07015C10.4288 7.59168 10.9073 5.55819 9.71114 4.36203L6.36187 1.01275C5.40494 0.175436 3.96954 0.175436 3.13222 1.01275L0.859497 3.28547C-1.41322 5.67781 1.09873 12.0175 6.72072 17.6395C12.3427 23.2615 18.6824 25.8931 21.0747 23.5007L23.3475 21.228C24.1848 20.2711 24.1848 18.8357 23.3475 17.9983Z"
                        fill="#21AC94" />
                    </g>
                    <defs>
                      <clipPath>
                        <rect width="24" height="24" fill="white" transform="translate(0 0.384766)" />
                      </clipPath>
                    </defs>
                  </svg>
                </div>
                <a href="tel:+14926618273" class="hover-content text-16">+1 492 6618 273</a>
              </div>
              <div class="d-flex align-items-center gap-8">
                <div class="svg">
                  <svg xmlns="http://www.w3.org/2000/svg" width="24" height="25" viewBox="0 0 24 25" fill="none">
                    <path
                      d="M14.0057 15.0888C13.4086 15.4869 12.7151 15.6973 12 15.6973C11.285 15.6973 10.5914 15.4869 9.99431 15.0888L0.159797 8.53229C0.105234 8.49591 0.0520781 8.45799 0 8.41899V19.1626C0 20.3944 0.999609 21.372 2.20936 21.372H21.7906C23.0224 21.372 24 20.3724 24 19.1626V8.41895C23.9478 8.45804 23.8945 8.49606 23.8398 8.53248L14.0057 15.0888Z"
                      fill="#21AC94" />
                    <path
                      d="M0.939844 7.36271L10.7744 13.9193C11.1466 14.1675 11.5733 14.2916 12 14.2916C12.4267 14.2916 12.8534 14.1675 13.2256 13.9193L23.0602 7.36271C23.6487 6.9706 24 6.31435 24 5.60607C24 4.38821 23.0092 3.39746 21.7914 3.39746H2.20861C0.990797 3.39751 0 4.38826 0 5.60724C0 6.31435 0.351375 6.9706 0.939844 7.36271Z"
                      fill="#21AC94" />
                  </svg>
                </div>
                <a href="mailto:support@example.com" class="hover-content text-16">support@example.com</a>
              </div>
            </div>
          </div>
        </div>
        <div class="text-center privacy-text">
          <p class="black">© 2025. All rights reserved by UI Paradox</p>
        </div>
      </div>
    </footer>
    <!-- Footer Banner End -->

    <!-- Main Wrapper End -->
  </div>
  <!-- Back To Top Start -->
  <button class="scrollToTopBtn"><i class="fa fa-arrow-up"></i></button>


  <!-- Mobile Menu Start -->
  <div class="mobile-nav__wrapper">
    <div class="mobile-nav__overlay mobile-nav__toggler"></div>
    <div class="mobile-nav__content">
      <span class="mobile-nav__close mobile-nav__toggler"><i class="fa fa-times"></i></span>
      <div class="logo-box">
        <a href="index.php" aria-label="logo image"><img src="assets/media/logo.webp" alt=""></a>
      </div>
      <div class="mobile-nav__container"></div>
      <ul class="mobile-nav__contact list-unstyled">
        <li>
          <i class="fas fa-envelope"></i>
          <a href="mailto:example@company.com">example@company.com</a>
        </li>
        <li>
          <i class="fa-solid fa-phone"></i>
          <a href="tel:+12345678">+123 (4567) -890</a>
        </li>
      </ul>
    </div>
  </div>
  <!-- Mobile Menu End -->

  <!-- Jquery Js -->
  <script src="assets/js/vendor/bootstrap.min.js"></script>
  <script src="assets/js/vendor/jquery-3.6.3.min.js"></script>
  <script src="assets/js/vendor/slick.min.js"></script>
  <script src="assets/js/vendor/jquery-validator.js"></script>
  <script src="assets/js/vendor/wow.js"></script>
  <script src="assets/js/vendor/jquery.magnific-popup.min.js"></script>
  <script src="assets/js/app.js"></script>
</body>

</html>